% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmaes_gen.R
\name{cmaes_gen}
\alias{cmaes_gen}
\title{Generator for cmaes_gen class.}
\usage{
cmaes_gen(population, ps_target = (1/(5 + (1/2)^0.5)), stepSize = 0.5,
  evoPath = rep(0, nrow(population)),
  covarianceMatrix = diag(nrow(population)))
}
\arguments{
\item{population}{The number of objective functions. A scalar value.}

\item{ps_target}{The target success rate. Used to initialize cmaes_gen$averageSuccessRate.}

\item{stepSize}{The initial step size.}

\item{evoPath}{A vector of numbers indicating evolution path of each variable.}

\item{covarianceMatrix}{Covariance matrix of the variables.}
}
\value{
An object of cmaes_gen class. It can be used as MO-CMA-ES parent. It is a 5 tuple: x (the design point, length = number of variable),averageSuccessRate (scalar),stepSize (scalar), evoPath (evolution path, vector, length = number of variable ),covarianceMatrix (square matrix with ncol = nrow = number of variable).
}
\description{
Create a list with cmaes_gen class. Basically, the function transform the population into a class that is accepted by the MOCMAES and SMOCMAES function.
}
\examples{
nVar <- 14
nObjective <- 5
nIndividual <- 100
crossoverProbability <- 1
ps_target <- 1 / (5 + ( 1 / 2  )^0.5 )
pop <- matrix(stats::runif(nIndividual*nVar), nrow = nVar) # create the population
a_list <- cmaes_gen(pop)
control <- list(successProbTarget=ps_target,crossoverProbability=crossoverProbability)
 \donttest{
# run a generation of MO-CMA-ES with standard WFG8 test function.
newGeneration <- MOCMAES(a_list,nObjective,WFG8,control,nObjective)
}
}
