\name{pooled.mean}
\alias{pooled.mean}
\title{Pooled Group Sample Mean Subroutine}
\description{
    Internal subroutine called by end-user function \code{\link[MVR]{mvr}} and internally by \code{\link[MVR]{MeanVarReg}} subroutine.
}
\usage{
    pooled.mean(x, block)
}
\arguments{
  \item{x}{\code{numeric} \code{vector} or \code{matrix} with variables in columns.}
  \item{block}{\code{vector} or \code{factor} grouping/blocking variable. 
               Must Have length equal to the sample size. 
               All group sample sizes must be greater than 1.}
}
\details{
    If \code{block} describes a unique sample group, ordinary sample mean will be computed.
}
\value{
    \code{numeric} \code{vector} of size the dimensionality where each entry is the variable-wise pooled group sample mean.
}
\references{
    \itemize{
        \item Dazard, J-E. and J. S. Rao (2010). "\emph{Regularized Variance Estimation and Variance Stabilization of High-Dimensional Data.}"
        JSM Proceedings. High-Dimensional Data Analysis and Variable Selection Section., Vancouver, BC. Canada, American Statistical Association.
        \item Dazard, J-E. and J. S. Rao (2011). "\emph{Joint Adaptive Mean-Variance Regularization and Variance Stabilization of High Dimensional Data.}" 
        Comput. Statist. Data Anal. (submitted).
    }
}
\author{
    \itemize{
        \item Jean-Eudes Dazard, Ph.D. \email{jxd101@case.edu}
        \item Hua Xu, Ph.D. \email{hxx58@case.edu}
        \item Alberto Santana, MBA. \email{ahs4@case.edu}
        \item J. Sunil Rao, Ph.D. \email{JRao@med.miami.edu}
    }
    Maintainer: Jean-Eudes Dazard, Ph.D. \email{jxd101@case.edu}
    
    Acknowledgments: This project was partially funded by the 
    National Institutes of Health (P30-CA043703 to J-E.DAZARD, R01-GM085205 to J.S.RAO), 
    and the National Science Foundation (DMS-0806076 to J.S.RAO).
}
\note{
    Internal function not to be called by end-user.
}
\seealso{
    \itemize{
        \item\code{\link[MVR]{pooled.mean}} Pooled group sample mean
        \item\code{\link[MVR]{mvr}} Mean-Variance Regularization and Variance Stabilization.
        \item\code{\link[MVR]{MeanVarReg}} Mean-Variance Regularization Core Function.
    }
}
\keyword{multiple sample groups}
\keyword{pooled mean estimator}
