% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{argrid_MSVARmdl}
\alias{argrid_MSVARmdl}
\title{Vector autoregressive moment grid}
\usage{
argrid_MSVARmdl(mu, sigma, k, ar, msmu, msvar)
}
\arguments{
\item{mu}{a (\code{k x q}) matrix of means in each regime (for \code{k} regimes and \code{q} time series).}

\item{sigma}{list with \code{k} regime specific (\code{q x q}) covariance matrices.}

\item{k}{integer determining the number of regimes.}

\item{ar}{number of autoregressive lags.}

\item{msmu}{Boolean indicator. If \code{TRUE} mean is subject to change. If \code{FALSE} mean is constant across regimes.}

\item{msvar}{Boolean indicator. If \code{TRUE} variance is subject to change. If \code{FALSE} variance is constant across regimes.}
}
\value{
List with M regime specific (\code{q x k}) matrices of means, List with \code{M} regime specific covariance matrices, and vector indicating the corresponded \code{1,..., k} regime.
}
\description{
Creates grid of means and covariance matrices consistent with a Markov-switching vector autoregressive model.
}
\keyword{internal}
