% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Risk.R
\name{Risk}
\alias{Risk}
\alias{Risk.MSGARCH_SPEC}
\alias{Risk.MSGARCH_ML_FIT}
\alias{Risk.MSGARCH_MCMC_FIT}
\title{Value-at-Risk and Expected-shortfall.}
\usage{
Risk(object, ...)

\method{Risk}{MSGARCH_SPEC}(object, par, data, alpha = c(0.01, 0.05),
  do.es = TRUE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)

\method{Risk}{MSGARCH_ML_FIT}(object, new.data = NULL, alpha = c(0.01,
  0.05), do.es = TRUE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)

\method{Risk}{MSGARCH_MCMC_FIT}(object, new.data = NULL, alpha = c(0.01,
  0.05), do.es = TRUE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{Risk}.}

\item{par}{Vector (of size d) or matrix (of size \code{n.mcmc} x d) of parameter estimates
where d must have
the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{alpha}{Vector (of size R) of Value-at-risk and Expected-shortfall levels.\cr
(Default: \code{alpha = c(0.01, 0.05)})}

\item{do.es}{Logical indicating if Expected-shortfall is also calculated.
(Default: \code{do.es = TRUE})}

\item{do.its}{Logical indicating if the in-sample risk estimators are returned.
(Default: \code{do.its = FALSE})}

\item{n.ahead}{Scalar indicating the number of step-ahead evaluation. (Default: \code{n.ahead = 1L})}

\item{ctr}{A list of control parameters:
\itemize{
\item \code{n.mesh} (integer >= 0) : Number of points for density
 evaluation. (Default: \code{n.mesh = 1000L})
\item \code{n.sim} (integer >= 0) :
Number indicating the number of simulation done for estimation of the
density at \code{n.ahead > 1}. (Default: \code{n.sim = 10000L})
}}

\item{new.data}{Vector (of size T*) of new observations. (Default \code{new.data = NULL})}
}
\value{
A list of class \code{MSGARCH_RISK} with the following elements:
\itemize{
\item \code{VaR}:\cr
If \code{do.its = FALSE}: Value-at-Risk at \code{t = T + T* + 1, ... ,t = T + T* + n.ahead} at the
chosen levels (matrix of size \code{n.ahead} x R).\cr
If \code{do.its = TRUE}: In-sample Value-at-Risk at the chosen levels (Matrix of size (T + T*) x R).
\item \code{ES}:\cr
If \code{do.its = FALSE}: Expected-shortfall at \code{t = T + T* + 1, ... ,t = T + T* + n.ahead} at the
chosen levels (matrix of size \code{n.ahead} x R).\cr
If \code{do.its = TRUE}: In-sample Expected-shortfall at the chosen levels (Matrix of size (T + T*) x R).
}
The \code{MSGARCH_RISK} contains the \code{plot} method.
Note that the MCMC/Bayesian risk estimator can take long time to calculate
depending on the size of the MCMC chain.
}
\description{
Method returning the Value-at-Risk and Expected-shortfall risk measures.
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian Value-at-Risk and Expected-shortfall are calculated.
Two or more step ahead risk measures are estimated via simulation of \code{n.sim} paths up to
\code{t = T + T* + n.ahead}.
If \code{do.its = FALSE}, the risk estimators at \code{t = T + T* + 1, ... ,t = T + T* + n.ahead}
are computed.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data with ML estimation
fit <- FitML(spec = spec, data = SMI)

# compute the Value-at-Risk and Expected-shortfall in-sample
risk.its <- Risk(object = fit, alpha = 0.05, do.es = FALSE, do.its = TRUE)
plot(risk.its)

# compute the one-step ahead Value-at-Risk and Expected-shortfall out-of-sample
Risk(object = fit, alpha = 0.05, do.es = FALSE, do.its = FALSE, n.ahead = 1L)
}
