% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransMat.R
\name{TransMat}
\alias{TransMat}
\alias{TransMat.MSGARCH_SPEC}
\alias{TransMat.MSGARCH_ML_FIT}
\title{Transition matrix.}
\usage{
TransMat(object, ...)

\method{TransMat}{MSGARCH_SPEC}(object, par = NULL, n.ahead = 1L, ...)

\method{TransMat}{MSGARCH_ML_FIT}(object, n.ahead = 1L, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}}
or fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}}.}

\item{...}{Not used. Other arguments to \code{TransMat}.}

\item{par}{Vector (of size d) of
parameter estimates (not required when using a fit object) where d must have
the same length as the default parameters of the specification.}

\item{n.ahead}{Number of steps ahead. (Default: \code{n.ahead = 1L})}
}
\value{
A matrix (of size K x K) in the case of a Markov-Switching model
 or a vector (of size K) in the case of a Mixture of GARCH model.
 The row indicates the starting states while the columns indicates the transition states.
}
\description{
Method returning the transition matrix.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data by ML
fit <- FitML(spec = spec, data = SMI)

# Extract the transition matrix 10 steps ahead
trans.mat <- TransMat(fit, n.ahead = 10)
print(trans.mat)
}
