% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.R
\name{BIC}
\alias{BIC}
\title{Compute Bayesian information criterion (BIC).}
\usage{
BIC(fit)
}
\arguments{
\item{fit}{Fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT} created with \code{\link{fit.bayes}}}
}
\value{
BIC value.
}
\description{
Compute Bayesian information criterion (BIC).
}
\details{
If a matrix of MCMC posterior draws estimates is given, the BIC on the posterior mean is calculated.
}
\examples{
\dontrun{
# load data
data("sp500")

# create model specification
spec = MSGARCH::create.spec() 

# fit the model by MLE                                                             
fit = MSGARCH::fit.mle(spec = spec, y = sp500)

# compute BIC
BIC = MSGARCH::BIC(fit)
}
}
\references{
Schwarz, G. (1978). Estimating the dimension of a model. \emph{Annals of Statistics}, 6, pp. 461-464.
}

