% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{spm}
\alias{spm}
\title{spm - calculates the dynamics of a Schaefer or Fox model}
\usage{
spm(inp, indat, schaefer = TRUE, year = "year", cats = "catch", index = "cpue")
}
\arguments{
\item{inp}{a vector of 3 or 4 model parameters (r,K,sigma) or (r, K,
Binit,sigma), you would use the latter if it was suspected that 
the fishery data started after some initial depletion had 
occurred. The sigma is an estimate of the variation of the cpue 
through time. This is required but is only used when fitting the 
model using negative log-likelihoods.}

\item{indat}{a matrix with at least columns year, catch, and cpue}

\item{schaefer}{a logical value determining whether the spm is to 
be a simple Schaefer model (p=1) or approximately a Fox model 
(p=1e-08). The default is TRUE}

\item{year}{the name of the year variable (in case your dataset 
names it fishingyearinwhichthecatchwastaken)}

\item{cats}{name of the catch variable, again this is for generality}

\item{index}{the name of the cpue variable, for generality}
}
\value{
a list of five objects; parameters plus q, then outmat, the 
    matrix with the dynamics, msy the maximum sustainable yield, and 
    sumout, which contains r,K,B0,msy,p,q,Depl, FinalB, and InitDepl
}
\description{
spm calculates the dynamics using a Schaefer of Fox 
    model. The outputs include  predicted Biomass, year, catch, cpue,
    predicted cpue, contributions to q, ssq, and depletion levels. 
    Generally it would be more sensible to use simpspm when fitting 
    a Schaefer model or a Fox model as those functions are designed 
    to generate only the log of predicted cpue as required by the 
    functions ssq and negLL, but the example shows how it could be 
    used. The function spm is used inside 'plotspmmod' and could be 
    used alone, to generate a full list of model outputs after the 
    model has been fitted. spm is designed for working with a
    single vector of an index of relative abundance. If there are 
    multiple vectors of the index then use simpspmM and spmCE.
}
\examples{
 data(abdat)   # spm is used inside plotspmmod
 pars <- log(c(0.35,7800,3500,0.05))
 ans <- plotspmmod(pars,abdat) #not fitted, just guessed
 bestSP <- fitSPM(pars=pars,fish=abdat,funk=simpspm)
 outfit(bestSP)  # best fitting estimates
 ans <- plotspmmod(bestSP$estimate,abdat,schaefer=TRUE)
 str(ans)
}
