% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{negnormL}
\alias{negnormL}
\title{negnormL an alternative -log-likelihood for normal errors}
\usage{
negnormL(pars, funk, funksig, indat, obs = "dl", ...)
}
\arguments{
\item{pars}{the vector of parameters, with sigma, the standard
deviation of the normal random deviates at the end.}

\item{funk}{the funk needed to generate the predicted values}

\item{funksig}{the function used to calculate the sigma value based
on the last parameter (=constant sigma) and the predicted values}

\item{indat}{the data.frame or matrix containing the obs and the 
independent variable used by funk}

\item{obs}{identifies the column name or column number that contains 
the observed data for comparison with the predicted from funk,
the default="dl"}

\item{...}{the standard R for including extra parameters needed by
funk but without having to be explicitly defined.}
}
\value{
the negative log-likelihood, for use in an optimizer, eg nlm
}
\description{
negnormL is an alternative to negNLL to produce
    -ve log-likelihoods for normal random errors, allowing for the
    sigma parameter to vary as a function of the predicted value. 
    In negnormL only one needs both a funk and a funksig, the former 
    to calculate the predicted values using funk, and funksig to
    calculate the changing sigma values relative to the predicted
    values. The example code illustrates an example funksig that
    does nothing to the sigma value.
}
\examples{
 data(blackisland)
 param <- c(Linf=173.65,K=0.2666,sigma=3.6)
 sigfunk <- function(pars,predobs) return(tail(pars,1))
 negnormL(par=param,funk=fabens,funksig=sigfunk,indat=blackisland,
          obs="dl",initL="l1",delT="dt")   # should be 291.1757
 param2 <- c(21.03,130.94,40.65,3.162)  
 negnormL(par=param2,funk=invl,funksig=sigfunk,indat=blackisland,
           obs="dl",initL="l1",delT="dt")  # should be 277.0186
}
