% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_sbx.R
\name{variation_sbx}
\alias{variation_sbx}
\title{Simulated binary crossover}
\usage{
variation_sbx(X, P, etax, pc = 1, eps = 1e-06, ...)
}
\arguments{
\item{X}{Population matrix}

\item{P}{Matrix of probabilities of selection for variation (created by
\code{\link[=define_neighborhood]{define_neighborhood()}}).}

\item{etax}{spread constant}

\item{pc}{variable-wise probability of recombination}

\item{eps}{smallest difference considered for recombination}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Matrix \code{X}' containing the recombined population
}
\description{
SBX implementation for the MOEA/D
}
\details{
This R implementation of the Simulated Binary Crossover reproduces the C code
implementation available in the R package \strong{emoa} 0.5-0, by Olaf Mersmann.
The differences between the present version and the original one are:
\itemize{
\item The operator is performed on the variables scaled to the \verb{[0, 1]}
interval, which simplifies the calculations.
\item Calculations are vectorized over variables, which also simplifies
the implementation.
}
}
\section{References}{

Deb, K. and Agrawal, R. B. (1995) Simulated binary crossover for continuous
search space. Complex Systems, 9 115-148 \cr

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr

Olaf Mersmann (2012). emoa: Evolutionary Multiobjective
Optimization Algorithms. R package version 0.5-0.\cr
http://CRAN.R-project.org/package=emoa
}

