% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delHdf.R
\name{delHdf}
\alias{delHdf}
\title{Delete Local MODIS Grid Files}
\usage{
delHdf(
  product,
  collection = NULL,
  extent = "global",
  tileV = NULL,
  tileH = NULL,
  begin = NULL,
  end = NULL,
  ask = TRUE,
  ...
)
}
\arguments{
\item{product}{\code{character}, see \code{\link{getProduct}}.}

\item{collection}{\code{character} or \code{integer}, see 
\code{\link{getCollection}}.}

\item{extent}{Extent information, defaults to \code{'global'}. See
\code{\link{getTile}}.}

\item{tileH, tileV}{\code{numeric} or \code{character}. Horizontal and 
vertical tile number, see \code{\link{getTile}}.}

\item{begin, end}{\code{Date} or \code{character}. Begin and end date of MODIS 
time series, see \code{\link{transDate}}.}

\item{ask}{\code{logical}. If \code{TRUE} (default), the user is being asked 
for deletion after checking.}

\item{...}{Arguments passed to \code{\link{MODISoptions}}, particularly 
\code{localArcPath}.}
}
\description{
Delete MODIS grid files to reduce the local storage.
}
\examples{
\dontrun{
# REMOVE "MYD11A2" from specific date range and area subset:
# delHdf(product="MYD11A2",begin="2010001",end="2010.02.01",extent="austria")
# or
# delHdf(product="MYD11A2",begin="2010001",end="2010.02.01",tileV=18:19,tileH=4)

# REMOVE "MOD11A2" and "MYD11A2" from specific date range but globaly:
# delHdf(product="M.D11A2",begin="2010001",end="2010.02.01") 

# REMOVE ALL "MOD11A2" from local archive:
# delHdf(product="MOD11A2") 
}

}
\author{
Matteo Mattiuzzi
}
