% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportSmoothedInsertions.R
\name{exportSmoothedInsertions}
\alias{exportSmoothedInsertions}
\title{\code{exportSmoothedInsertions}}
\usage{
exportSmoothedInsertions(
  SampleTileObj,
  cellPopulation,
  outDir = NULL,
  sumWidth = 10,
  medianWidth = 11,
  force = FALSE,
  slow = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObj}{A MultiAssayExperiment or RangedSummarizedExperiment
from MOCHA}

\item{cellPopulation}{A string denoting the cell population of interest}

\item{outDir}{Directory to write output bigwig files. Default is NULL, where
the directory in `SampleTileObj@metadata$Directory` will be used.}

\item{sumWidth}{Window size for rolling sum in basepairs. Default is 10.}

\item{medianWidth}{Window size for rolling median in basepairs. Must be odd.
Default is 11.}

\item{force}{Set TRUE to overwrite existing files. Default is FALSE.}

\item{slow}{Set TRUE to bypass optimisations and compute smoothing filter
directly on the whole genome. May run slower and consume more RAM. Default
is FALSE.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
outPaths List of paths of exported insertion files
}
\description{
\code{exportSmoothedInsertions} Takes a SampleTileMatrix with
  linked insertion files and applies a smoothing filter (a rolling sum then
  rolling median) to the insertions, finally exporting the smoothed insertion
  files to bigwig format.
}
\examples{
\dontrun{
# Depends on and manipulates files on filesystem
outPath <- MOCHA::exportSmoothedInsertions(
  SampleTileObj,
  cellPopulation = "CD4 Naive", sumWidth = 10, medianWidth = 11, verbose = FALSE
)
}

}
