% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JointDistribution.R
\name{JointDistribution}
\alias{JointDistribution}
\title{Joint distribution}
\usage{
JointDistribution(theta, psi, input)
}
\arguments{
\item{theta}{- a vector that sum to 1, denotes probability of latent class.}

\item{psi}{- an array with dimension c(k,p,d), specific probability for each variables in each component.}

\item{input}{- a p-dimensional vector denote specific variable, e.g., assume p=2, input = (1,2) means the joint probability of V_1=1 and V_2=2.}
}
\description{
This function is used to compute joint distribution given the estimates of theta and psi.
}
\note{
k - number of components

n - number of observations

p - number of variables

d - number of choices. Here d are identical for all variables.
}
\examples{
k<-2; p<-2; d<-2;
theta<-c(0.3,0.7)
psi <- array(rdirichlet(k*p,rep(1,d)),dim = c(k,p,d))
JointDistribution(theta,psi,input = c(1,1))
}

