% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_mixed.R
\name{robust_mixed}
\alias{robust_mixed}
\title{Robust standard errors for mixed models}
\usage{
robust_mixed(m1, digits = 4, Gname = NULL)
}
\arguments{
\item{m1}{lme4 or nlme model object.}

\item{digits}{Number of digits for output.}

\item{Gname}{Group/cluster name if more than two levels of clustering.}
}
\value{
Returns a data frame containing the estimates, model-based and empirical standard errors,
as well as the t-statistic, degrees of freedom, and p values.
\item{estimate}{Estimated regression coefficients.}
\item{mb.se}{The model-based standard errors.}
\item{robust.se}{The empirical, robust standard errors.}
\item{t.stat}{The t-statistics (estimate / robust.se).}
\item{df}{Between-within degrees of freedom (df).}
\item{p.values}{The p values based on the t-statistic and the df.}
\item{Sig}{Stars symbolically showing statistical significance.}
}
\description{
If there are more than two levels of clustering, the clustering variable should
be set at the highest level. Should not be used for inferential statistical testing purposes
if there are only a few clusters (e.g., < 40). The robust standard errors (CR0) are
based on the formulation of Liang and Zeger (1986). For a few clusters, use the
CR2 version using the \code{clubSandwich} package (see Pustejovsky & Tipton, 2018).
}
\examples{
data(mtcars)
require(lme4)
robust_mixed(lmer(mpg ~ wt + am + (1|cyl), data = mtcars))
}
\references{
Liang, K.Y., & Zeger, S. L. (1986). Longitudinal data analysis using generalized linear models. \emph{Biometrika, 73}(1), 13–22.
\doi{10.1093/biomet/73.1.13}

Pustejovsky, J. E. & Tipton, E. (2018). Small sample methods for
cluster-robust variance estimation and hypothesis testing in fixed effects
models. \emph{Journal of Business and Economic Statistics, 36}(4), 672-683.
\doi{10.1080/07350015.2016.1247004}
}
