colpositive.mle <- function(x, distr = "gamma", tol = 1e-07, maxiters = 100, parallel = FALSE){
  if ( distr == "gamma" ) {
    res <- Rfast::colgammamle(x, tol = 1e-07)
  } else if ( distr == "weibull" ) {
    res <- Rfast::colweibull.mle(x, tol = tol, maxiters = maxiters, parallel = parallel) ###
  } else if ( distr == "pareto" ) {
    res <- Rfast::colpareto.mle(x)
  } else if ( distr == "exp" ) {
    res <- Rfast::colexpmle(x)
  } else if ( distr == "exp2" ) {
    res <- Rfast::colexp2.mle(x)
  } else if ( distr == "maxboltz" ) {
    res <- Rfast::colmaxboltz.mle(x)
  } else if ( distr == "lindley" ) {
    res <- Rfast::collindley.mle(x)
  } else if ( distr == "rayleigh" ) {
    res <- Rfast::colrayleigh.mle(x)
  } else if ( distr == "lognorm" ) {
    res <- Rfast2::collognorm.mle(x)
  } else if ( distr == "halfnorm" ) {
    res <- Rfast2::colhalfnorm.mle(x)
  } else if ( distr == "normlog" ) {
    res <- Rfast::colnormlog.mle(x)
  } else if ( distr == "invgauss" ) {
    res <- Rfast::colinvgauss.mle(x)
  } else if ( distr == "powerlaw" ) {
    res <- Rfast2::colpowerlaw.mle(x)
  } else if ( distr == "chisq" ) {
    res <- .colchisq.mle(x)
  } else if ( distr == "foldnorm" ) {
    res <- .colfoldnorm.mle(x)
  } else if ( distr == "betaprime" ) {
    res <- .colbetaprime.mle(x)
  } else if ( distr == "logcauchy" ) {
    res <- .collogcauchy.mle(x)
  } else if ( distr == "loglogistic" ) {
    res <- .colloglogistic.mle(x)
  } else if ( distr == "zigamma" ) {
    res <- .colzigamma.mle(x)
  } else if ( distr == "ziweibull" ) {
    res <- .colziweibull.mle(x)
  } else if ( distr == "epois" ) {
    res <- .colepois.mle(x)
  } else if ( distr == "gep" ) {
    res <- .colgep.mle(x)
  } else if ( distr == "pe" ) {
    res <- .colpe.mle(x)
  } else if ( distr == "gep" ) {
    res <- .colgep.mle(x)
  } else if ( distr == "halfcauchy" ) {
    res <- .colhalfcauchy.mle
  } else if ( distr == "wp" ) {
    res <- .colwp.mle(x)
  } else if ( distr == "be" ) {
    res <- .colbe.mle(x)
  } else if ( distr == "frechet2" ) {
    res <- .colfng.mle(x)
  }
  res
}


.colchisq.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast::chisq.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters", "loglik", "nu")
  res
}

.colfoldnorm.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist(Rfast::foldnorm.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters", "loglik", "mean", "sigma squared")
  res
}

.colbetaprime.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast::betaprime.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters", "loglik", "alpha", "beta")
  res
}

.collogcauchy.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast::logcauchy.mle(x[,i], tol = tol) )
  colnames(res) <- c("loglik", "location", "scale")
  res
}

.colloglogistic.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast::loglogistic.mle(x[,i], tol = tol) )
  colnames(res) <- c("loglik", "location", "scale")
  res
}

.colzigamma.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 5)
  for ( i in 1:dim(x)[2] )  res[i,] <- unlist(Rfast2::zigamma.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters", "loglik", "prop1", "shape", "scale")
  res
}

.colziweibull.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 5)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast2::ziweibull.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters","loglik", "prop1", "shape", "scale")
  res
}

.colepois.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( geppe::epois.mle(x[, i]) )
  colnames(res) <- c("beta", "lambda", "loglik")
  res
}

.colgep.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( geppe::gep.mle(x[, i]) )
  colnames(res) <- c("beta","alpha","lambda", "loglik")
  res
}

.colpe.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( geppe::pe.mle(x[, i]) )
  colnames(res) <- c("theta","lambda", "loglik")
  res
}

.colhalfcauchy.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast2::halfcauchy.mle(x[, i], tol = tol ) )
  colnames(res) <- c("iters","loglik", "scale")
  res
}

.colwp.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( .wp.mle(x[, i]) )
  colnames(res) <- c("alpha","beta", "lambda","loglik")
  res
}

.colbe.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 4)
  for (i in 1:dim(x)[2] ) res[i, ] <- unlist( .be.mle(x[, i]) )
  colnames(res) <- c("alpha","beta", "lambda","loglik")
  res
}

.colfng.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 3)
  for (i in 1:dim(x)[2] )  res[i, ] <- unlist( .fng.mle(x[, i]) )
  colnames(res) <- c("beta", "gamma","loglik")
  res
}


