% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameter_estimates.R
\name{get_item_parameter_estimates}
\alias{get_item_parameter_estimates}
\title{Get trainable variables from the decoder, which serve as item parameter estimates.}
\usage{
get_item_parameter_estimates(decoder, model_type = 2)
}
\arguments{
\item{decoder}{a trained keras model; can either be the decoder or vae returned from \code{build_vae_independent()} or \code{build_vae_correlated}}

\item{model_type}{either 1 or 2, specifying a 1 parameter (1PL) or 2 parameter (2PL) model; if 1PL, then only the difficulty parameter estimates (output layer bias) will be returned; if 2PL, then the discrimination parameter estimates (output layer weights) will also be returned}
}
\value{
a list which contains item parameter estimates; the length of this list is equal to model_type - the first entry in the list holds the difficulty parameter estimates, and the second entry (if 2PL) contains discrimination parameter estimates
}
\description{
Get trainable variables from the decoder, which serve as item parameter estimates.
}
\examples{
\donttest{
Q <- matrix(c(1,0,1,1,0,1,1,0), nrow = 2, ncol = 4)
models <- build_vae_independent(4, 2, Q, model_type = 2)
decoder <- models[[2]]
item_parameter_estimates <- get_item_parameter_estimates(decoder, model_type = 2)
difficulty_est <- item_parameter_estimates[[1]]
discrimination_est <- item_parameter_estimates[[2]]
}
}
