% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson.R
\name{mi_wald}
\alias{mi_wald}
\title{Calculates the specified Wald CI of a binomial proportion
variable, given imputed data sets.}
\usage{
mi_wald(mids_obj, response, ci_level = 0.95, summaries = TRUE)
}
\arguments{
\item{mids_obj}{mids object created by mice package}

\item{response}{string name of response variable (must be 0-1 valued)}

\item{ci_level}{desired confidence interval level (defaults to 95\%)}

\item{summaries}{boolean: should summary helper values be printed (default TRUE)}
}
\value{
two-length vector of Wald lower CI and upper CI
}
\description{
Calculates the specified Wald CI of a binomial proportion
variable, given imputed data sets.
}
\examples{
imp = mice::mice(mice::nhanes \%>\% dplyr::mutate(hyp = hyp-1))
mi_wald(imp, "hyp", 0.95)

}
