% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{datagen_uni}
\alias{datagen_uni}
\title{Unidimensional data generation.}
\usage{
datagen_uni(J, K, n, fixed, mipattern, etadist = NULL)
}
\arguments{
\item{J}{Integer. Number of indicators.}

\item{K}{Integer. Number of groups.}

\item{n}{Integer. Number of observations within group.}

\item{fixed}{Named List. lambda, resid_log, nu, in that order.}

\item{mipattern}{List. See details.}

\item{etadist}{(Default: NULL). NULL, "std", or a list of two. If NULL (Default), all groups have latent scores distributed standard normal. If "std", means are standard normal, and (log) latent SDs are also standard normal (i.e., standard log normal; product to 1). If a list, slot one provides the K means, slot two provides the K log SDs. These should have a mean of zero (sum to zero) and a mean of 1 (product to 1), respectively.}
}
\value{
List of meta(data), params, data, and a data frame.
}
\description{
Generates unidimensional data for testing the HMRE/MIRES approach.
}
\details{
\code{mipattern} is a list specifying a pattern of MI.
The first entry should be a string specifying one of: constant, random, none, items, params, or custom.
The other entries depend on the specification desired, as described below.
\describe{
  \item{constant}{ (2) Numeric: All RE SDs are set to this value.}
  \item{random}{ (2) Numeric: All RE SDs are generated between 0 and this value.}
  \item{none}{ All RE SDs set to zero (full invariance).}
  \item{items}{ (2) Numeric: Value of RE SDs for (3) items. E.g., "items", .4, 4 would set all parameters for items 1 to 4 to have an RE SD of .4.}
  \item{params}{ (2) Numeric: Value of RE SD for parameter type (3), where (3) is an integer (0: Loadings, 1: Residual SDs, 2: Intercepts). E.g., "params", .4, 2 would set all RE-SDs of intercepts to be .4.}
  \item{custom}{ (2) Numeric: Specify all 3J RE-SDs manually in order of loadings, residual log SDs, and intercepts.}
}
Note that this is \emph{not} the generative model specified by MIRES, but a convenience function for meeting the bare assumptions while generating MI or non-MI data.
}
\author{
Stephen Martin
}
\keyword{internal}
