% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_actigraph_meta}
\alias{import_actigraph_meta}
\title{Import The meta information stored in Actigraph RAW or summary csv file.}
\usage{
import_actigraph_meta(filepath, header = TRUE)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{header}{logical. Whether the Actigraph RAW or summary csv file includes
column names. Default is TRUE.}
}
\value{
list. A list of Actigraph device meta information.
}
\description{
\code{import_actigraph_meta} imports meta information stored in the Actigraph
summary csv file.
}
\details{
The returned meta information includes following fields.

\itemize{ \item sr: Sampling rate in Hz. \item fw: Firmware version. For
example "1.7.0". \item sw: Software version of Actilife. For example "6.13.0".
\item sn: Serial number of the device. \item st: Start time of the data, in
POSIXct format. \item dt: Download time of the data, in POSIXct format. \item
at: Type of the device. Could be "MAT","CLE", "MOS" or "TAS", corresponding
to different Actigraph devices. \item imu: Whether the file is about
Actigraph GT9X IMU data. \item gr: The dynamic range in \eqn{g} unit. \item
vs: The voltage level of the device, may be used in AD conversion. See
\code{\link{import_actigraph_csv}}. \item res: The resolution or the number of
bits used to store quantized voltage values of the device, may be used in AD
conversion. See \code{\link{import_actigraph_csv}}. }
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to get related meta information such as sampling
  rate, firmware version from Actigraph devices.
}

\examples{
  default_ops = options()
  options(digits.secs=3)

  # Use the sample actigraph csv file provided by the package
  filepath = system.file('extdata', 'actigraph.csv', package='MIMSunit')

  # Check file format
  readLines(filepath)[1:15]

  # Load the meta headers of input file
  import_actigraph_meta(filepath, header=TRUE)

  # Restore default options
  options(default_ops)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
