% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelfromlambdas.R
\name{modelfromlambdas}
\alias{modelfromlambdas}
\title{Maxent model from .lambdas file.}
\usage{
modelfromlambdas(file, raw = FALSE)
}
\arguments{
\item{file}{pathway to the .lambdas file of a given Maxent model}

\item{raw}{Logical. Should the function return raw Maxent output instead of
PRO?}
}
\value{
returns an R function (object).
}
\description{
\code{modelFromLambdas} returns an R function for a given Maxent model, using
the .lambdas file produced by the MaxEnt program to parameterize the model.
The returned function gives predictions of the model in "raw output" format
from values of explanatory variables.
}
\details{
The \code{modelFromLambdas} function returns a Maxent model, in the form of a
function that calculates Maxent predictions for given values of explanatory
variables.

Input to the function returned by \code{modelFromLambdas} are values of
explanatory variables in the model. The format of this input must be an array
(matrix or data frame) with m columns, and column names must match variable
names in the .lambdas file used to reproduce the model.
}
\keyword{internal}

