% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetReplStats_func_20200914.R
\name{GetReplStats}
\alias{GetReplStats}
\title{GetReplStats function}
\usage{
GetReplStats(filepath)
}
\arguments{
\item{filepath}{is a user defined path to the folder where the output files
from the ReplMatch() function have been saved.}
}
\value{
A list containing the number of replicate sets with zero incongruent
  sequences, the proportion of replicate sets with zero incongruent
  sequences, the mean of the mean proportion of incongruent sequences across
  all replicate sets, and the repeatability of the sequencing experiment.
}
\description{
\code{\link{GetReplStats}} uses the output files produced by the ReplMatch()
function to calculate statistics on the agreement between replicated samples
in the sequencing experiment.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools – an R package for MHC high‐throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non‐model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
filepath <- system.file("extdata/ReplMatchOut/", package="MHCtools")
GetReplStats(filepath)
}
\seealso{
\code{\link{ReplMatch}}; \code{\link{GetReplTable}}
}
