% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-plot.R
\name{summarize_humans_epiSEIR}
\alias{summarize_humans_epiSEIR}
\title{Summarize Humans (One Node or Metapopulation Network, SEI Mosquitoes - SEIR Humans)}
\usage{
summarize_humans_epiSEIR(out)
}
\arguments{
\item{out}{the output of \code{\link[MGDrivE2]{sim_trajectory_R}}}
}
\value{
a 4 to 6 column dataframe for plotting with ggplot2
}
\description{
For \code{MGDrivE2} simulations of mosquito epidemiological dynamics in a
node or network, this function summarizes human infection status, S, E, I, and R.
It uses \code{\link{base_summarize_humans}} to do all of the work.
}
\details{
The return object depends on the data provided. If the simulation was only 1 node,
then no \code{node} designation is returned. If only one repetition was performed,
no \code{rep} designation is returned. Columns always returned include: \code{time},
\code{inf}, \code{genotype}, and \code{value}.

For examples of using this function, see:
\code{vignette("seir-dynamics", package = "MGDrivE2")}
}
