% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-trajectory-R.R
\name{sim_trajectory_base_R}
\alias{sim_trajectory_base_R}
\title{Simulate Trajectory From one SPN Model}
\usage{
sim_trajectory_base_R(
  x0,
  times,
  dt = 1,
  num_reps,
  stepFun,
  events = NULL,
  Sout = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x0}{the initial marking of the SPN (initial state)}

\item{times}{sequence of sampling times}

\item{dt}{the time-step at which to return output (\strong{not} the time-step of the sampling algorithm)}

\item{num_reps}{number of repetitions to run}

\item{stepFun}{a sampling function}

\item{events}{a \code{data.frame} of events (uses the same format as required in package \code{deSolve} for consistency, see \code{\link[deSolve]{events}} for more information)}

\item{Sout}{an optional matrix to track event firings}

\item{verbose}{print a progress bar?}
}
\value{
matrix of sampled values
}
\description{
This is an internal function to \code{\link{sim_trajectory_R}}. It does the
actual sampling once all of the functions have been checked and setup.
}
