% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kfilter.R
\name{Kfilter_single}
\alias{Kfilter_single}
\title{The Kolmogorov filter for variable screening in high-dimensional binary classification}
\usage{
Kfilter_single(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by SIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
The Kolmogorov filter for variable screening in high-dimensional binary classification
}
\examples{
n=100;
p=200;
pho=0.5;
data=gendata3(n,p,pho)
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A=Kfilter_single(X,Y,n/log(n));A

}
\references{
#' Mai, Q., & Zou, H. (2013). The Kolmogorov filter for variable screening in high-dimensional binary classification. Biometrika, 100(1), 229-234.
}
