% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{ComputeInterestingTuples}
\alias{ComputeInterestingTuples}
\title{Interesting tuples}
\usage{
ComputeInterestingTuples(
  data,
  decision,
  dimensions = 2,
  divisions = NULL,
  discretizations = 1,
  seed = NULL,
  range = NULL,
  pc.xi = 0.25,
  ig.thr,
  I.lower,
  interesting.vars = vector(mode = "integer"),
  require.all.vars = FALSE
)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{dimensions}{number of dimensions (a positive integer; 5 max) - FIXME: only 2D supported for now!}

\item{divisions}{number of divisions (from 1 to 15; \code{NULL} selects probable optimal number)}

\item{discretizations}{number of discretizations}

\item{seed}{seed for PRNG used during discretizations (\code{NULL} for random)}

\item{range}{discretization range (from 0.0 to 1.0; \code{NULL} selects probable optimal number)}

\item{pc.xi}{parameter xi used to compute pseudocounts (the default is recommended not to be changed)}

\item{ig.thr}{IG threshold above which the tuple is interesting}

\item{I.lower}{IG values computed for lower dimension (1D for 2D, etc.)}

\item{interesting.vars}{variables for which to check the IGs (none = all)}

\item{require.all.vars}{boolean whether to require tuple to consist of only interesting.vars}
}
\value{
A \code{\link{data.frame}} or \code{\link{NULL}} (following a warning) if no tuples are found.

 The following columns are present in the \code{\link{data.frame}}:
 \itemize{
   \item \code{Var} -- interesting variable index
   \item \code{Tuple.1, Tuple.2, ...} -- corresponding tuple (up to \code{dimensions} columns)
   \item \code{IG} -- information gain achieved by \code{var} in \code{Tuple.*}
 }

 Additionally attribute named \code{run.params} with run parameters is set on the result.
}
\description{
Interesting tuples
}
\examples{
\donttest{
ig.1d <- ComputeMaxInfoGains(madelon$data, madelon$decision, dimensions = 1, divisions = 1,
                             range = 0, seed = 0)
ComputeInterestingTuples(madelon$data, madelon$decision, dimensions = 2, divisions = 1,
                         range = 0, seed = 0, ig.thr = 100, I.lower = ig.1d$IG)
}
}
