% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cimproved.R
\name{Cimproved}
\alias{Cimproved}
\title{Calculate the critical value for our improved test}
\usage{
Cimproved(nS, bS, M, DR, Fp, alpha)
}
\arguments{
\item{nS}{A vector of sample sizes, with each entry corresponding to an observation pattern.}

\item{bS}{A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.}

\item{M}{A vector of positive integers giving the alphabet sizes of the discrete variables.}

\item{DR}{The quantity \eqn{D_R} appearing in \insertCite{BS2022;textual}{MCARtest}.}

\item{Fp}{The quantity \eqn{F'} appearing in \insertCite{BS2022;textual}{MCARtest}.}

\item{alpha}{The desired significance level \eqn{\alpha} of the test.}
}
\value{
The critical value \eqn{C_\alpha'} defined in \insertCite{BS2022;textual}{MCARtest}.
}
\description{
Calculate a critical value for an MCAR test based on knowledge of the facet
structure of the Minkowski sum calculated by \code{ConsMinkSumHrep}.
}
\examples{
bS=matrix(c(1,1,0, 1,0,1, 0,1,1),byrow=TRUE,ncol=3)
r=4; s=3
M=c(r,s,2)
Cimproved(rep(1000,3),bS,M,1,(2^r-2)*(2^s-2),0.05)
}
\references{
\insertRef{BS2022}{MCARtest}
}
