% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbnma-class.R
\name{get.relative}
\alias{get.relative}
\title{Calculates relative effects/mean differences at a particular time-point}
\usage{
get.relative(
  mbnma,
  time = max(mbnma$model.arg$jagsdata$time, na.rm = TRUE),
  treats = mbnma$network$treatments,
  classes = NULL
)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{time}{A numeric value for the time at which to estimate relative effects/mean differences.}

\item{treats}{A character vector of treatment names for which to calculate relative effects/mean differences.
Must be a subset of \code{mbnma$network$treatments}}

\item{classes}{A character vector of class names for which to calculate relative effects/mean differences from.
Must be a subset of \code{mbnma$network$classes}. Only works for class effect models.}
}
\value{
An object of class \code{"relative.array"} list containing:
\itemize{
\item The time-point for which results are estimated
\item Matrices of posterior means, medians, SDs and upper and lower 95\% credible intervals for the
differences between each treatment
\item An array containing MCMC results for the differences between all treatments specified in \code{treats}
or all classes specified in \code{classes}.
}

Results are reported in tables as the row-defined treatment minus the column-defined treatment.
}
\description{
Uses mbnma time-course parameter estimates to calculate treatment
differences between treatments or classes at a particular time-point.
Can be used to compare treatments evaluated in studies at different follow-up times.
}
\examples{
\donttest{
# Create an mb.network object from a dataset
alognet <- mb.network(alog_pcfb)

# Run a quadratic time-course MBNMA using the alogliptin dataset
mbnma <- mb.run(alognet,
  fun=tpoly(degree=2,
  pool.1="rel", method.1="random",
  pool.2="rel", method.2="common"
  )
)

# Calculate differences between all treatments at 20 weeks follow-up
allres <- get.relative(mbnma, time=20)

# Calculate difference between a subset of treatments at 10 weeks follow-up
subres <- get.relative(mbnma, time=10,
  treats=c("alog_50", "alog_25", "placebo"))
}
}
