% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{sim.marx}
\alias{sim.marx}
\title{The simulation of MARX processes}
\usage{
sim.marx(dist.eps, dist.x, obs, c_par, nc_par, exo_par)
}
\arguments{
\item{dist.eps}{vector containing the error distribution and its parameters (options: t, normal, stable).}

\item{dist.x}{vector containing the distribution of x and its parameters (options: t, normal, stable). Specify NULL or "not" if not wanted.}

\item{obs}{Number of observations for simulated process.}

\item{c_par}{vector of causal parameters.}

\item{nc_par}{vector of noncausal parameters.}

\item{exo_par}{Parameter of the exogenous variable.}
}
\value{
\item{y}{Simulated data y.}

\item{x}{Simulated data x (exogenous variable).}
}
\description{
This function allows you to simulate MARX processes based on different underlying distribution.
}
\examples{
dist.eps <- c('t',1,1) ## t-distributed errors with 1 degree of freedom and scale parameter 1
dist.x   <- c('normal',0,1) ## standard normally distributed x variable
obs <- 100
c_par <- c(0.2,0.4)
nc_par <- 0.8
exo_par <- 0.5
sim.marx(dist.eps,dist.x,obs,c_par,nc_par,exo_par) ## Simulates a MARX(2,1,1) process
}
\author{
Sean Telg
}
\keyword{simulation}

