% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{bic}
\alias{bic}
\title{The Bayesian/Schwarz information criterion (BIC) function}
\usage{
bic(y, x, p_max)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_max}{Maximum number of autoregressive terms to be included.}
}
\value{
\item{p}{Lag order chosen by BIC.}

\item{values}{Vector containing values BIc for p = 0 up to p_max.}
}
\description{
This function allows you to calculate the Bayesian/Schwarz information criteria (BIC) for ARX models.
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
bic(data$y, data$x,8)
}
\author{
Sean Telg
}
\keyword{selection}

