% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_3_3_CheckAlignment_PSI_Gene.R
\name{CheckAlignment.PSI.Exp}
\alias{CheckAlignment.PSI.Exp}
\title{Check Alignment for both splicing and gene data}
\usage{
CheckAlignment.PSI.Exp(MarvelObject)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CheckAlignment} function.}
}
\value{
An object of class S3. The original \code{MarvelObject$SplicePheno}, \code{MarvelObject$PSI}, \code{MarvelObject$GenePheno}, and \code{MarvelObject$Exp} are updated.
}
\description{
\code{CheckAlignment} subset overlapping samples between splicing and gene data.
}
\details{
This function subset overlapping samples between splicing and gene data and aligns the order of sampleIDs between the two data types.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CheckAlignment.PSI.Exp(MarvelObject=marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
