% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize spectra and peaks}
\usage{
normalize(spec, peaks, normMeth, normMz, normTol)
}
\arguments{
\item{spec}{List of MALDIquant::MassSpectrum}

\item{peaks}{List of MALDIquant::MassPeaks}

\item{normMeth}{Character, normalization method. Options are "TIC", "median" and "mz".}

\item{normMz}{Numeric, mz used to normalize.}

\item{normTol}{Numeric, tolerance around normMz.}
}
\value{
List of lists of normalized MALDIquant::MassSpectrum, normalized MALDIquant::MassPeaks,
normalization factors as well as indicies of spectra containing the \code{normMz} in case of \code{normMeth = "mz"},
}
\description{
Normalize spectra and peaks
}
\examples{
data(Blank2022spec)
data(Blank2022peaks)
norm <- normalize(Blank2022spec, Blank2022peaks, normMeth = "mz", normMz = 760.585, normTol = 0.1)

# normalization factors
norm$factor 
}
