% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualitiyMetrics.R
\name{calculateZPrime}
\alias{calculateZPrime}
\title{Calculate Z'-factor of assay quality}
\usage{
calculateZPrime(res, internal = TRUE, nConc = 2)
}
\arguments{
\item{res}{Object of class MALDIassay}

\item{internal}{Logical, currently only the internal implementation,
using \code{nConc} top and bottom concentrations, is implemented.}

\item{nConc}{Numeric, number of top and bottom concentrations to be used
to calculate the pseudo positive and negative control.
Only used if \code{internal} is TRUE}
}
\value{
Numeric vector of Z'-factors.
}
\description{
Calculate Z'-factor of assay quality
}
\details{
The most common way to measure the quality of an assay is the so-called Z'-factor,
which describes the separation of the positive and negative control in terms of their standard deviations \eqn{\sigma_p} and \eqn{\sigma_n}.
The Z'-factor is defined as \href{https://pubmed.ncbi.nlm.nih.gov/10838414/}{Ji-Hu Zhang et al., A simple statistical parameter for use in evaluation and validation of high throughput screening assays}.
\deqn{Z' = 1 - (3 * (\sigma_p+\sigma_n))/|\mu_p-\mu_n|}

where \eqn{\mu_p} and \eqn{\mu_p} is the mean value of the positive (response expected) and negative (no response expected) control, respectively.
Therefore, the assay quality is \strong{independent of the shape of the concentration response curve} and solely depend on two control values.

Note, if \code{internal} is set to TRUE, the \code{nConc} highest concentrations are assumed as positive control,
whereas the \code{nConc} lowest concentrations are used as negative.\tabular{ll}{
   \strong{Value} \tab \strong{Interpretation} \cr
   Z' ~ 1 \tab perfect assay \cr
   1 > Z' > 0.5 \tab excellent assay \cr
   0.5 > Z' > 0 \tab moderate assay \cr
   Z' = 0 \tab good only for yes/no response \cr
   Z' < 0 \tab unacceptable \cr
}
}
\examples{
# see example for `fitCurve()` to see how this data was generated
data(Blank2022res)
calculateZPrime(Blank2022res, nConc = 2)       
 
}
