% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateOncoPlot.R
\name{generateOncoPlot}
\alias{generateOncoPlot}
\title{Function to generate a dashboard from a MAF file}
\usage{
generateOncoPlot(
  maf,
  cohort_freq_thresh = 0.01,
  auto_adjust_cohort_freq = TRUE,
  genes_to_plot = NULL,
  include_all = FALSE,
  oncomat_only = FALSE,
  title_text = "",
  custom_column_order = NULL,
  add_clinical_annotations = F,
  clin_data_colors = NULL
)
}
\arguments{
\item{maf}{The MAF object}

\item{cohort_freq_thresh}{Fraction of cohort that a gene must be mutated to select for display}

\item{auto_adjust_cohort_freq}{Whether or not to automatically adjust the frequen}

\item{genes_to_plot}{Character vector, data frame, or tab-delimited file name with genes to plot.
Data frame or file should contain a column named "Hugo_Symbol" with gene symbols, and optionally,
a column named "Reason" for labeling the plot}

\item{include_all}{Flag to include all the samples including the missing one (Default: FALSE)}

\item{oncomat_only}{Whether or not to return just the oncoplot matrix}

\item{title_text}{The title of the plot}

\item{custom_column_order}{A list containing the order of samples to show in the plot (Optional)}

\item{add_clinical_annotations}{Whether or not to try to plot column annotations from the 'clinical.data' slot of the MAF object}

\item{clin_data_colors}{Named list of colors for clinical annoations}
}
\value{
A ComplexHeatmap object if 'oncomat_only' is FALSE or a character matrix if 'oncomat_only' is TRUE.
}
\description{
This function created an HTML file containing the
different figures and plots explaining the MAF dataset.
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
generateOncoPlot(read.maf(maf))

}
\author{
Mayank Tandon, Ashish Jain
}
