% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clust_Valid.R
\name{Clust_Valid}
\alias{Clust_Valid}
\title{Cluster Evaluation by External Measures}
\usage{
Clust_Valid(predcpx, refcpx)
}
\arguments{
\item{predcpx}{A list containing predicted complexes.}

\item{refcpx}{A list containing reference complexes (i.e.,
CORUM complexes).}
}
\value{
A list containing the numerical values for each
evaluation metrics.
}
\description{
This function evaluate the quality of clusters by comparing
clustering-derived partitions to known labels (i.e., CORUM complexes) and
assess the similarity between them using quality measures including
overlap score (O), sensitivity (Sn), clustering-wise positive predictive
value (PPV), geometric accuracy (Acc), and maximum matching ratio (MMR).
}
\details{
Clust_Valid
}
\examples{
# Load known reference complexes
data(refcpx)
# Select subset of complexes to be used as an instance sets for predicted
# complexes
predcpx <- refcpx[5:15]
Eval_result <- Clust_Valid(predcpx,refcpx)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
