/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.EmptyIcon;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.PopupMenuTrigger;
import uk.ac.rhul.cs.cl1.ui.RemoveClusterFromResultAction;
import uk.ac.rhul.cs.cl1.ui.ResultViewerPanel;
import uk.ac.rhul.cs.cl1.ui.ShowDetailedResultsAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeTask;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CopyClusterToClipboardAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ExtractClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.FindAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.SaveClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.SaveClusteringAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoscapeResultViewerPanel
extends ResultViewerPanel
implements CytoPanelComponent,
ListSelectionListener,
NetworkViewAddedListener,
NetworkViewAboutToBeDestroyedListener {
    private ClusterONECytoscapeApp app = null;
    private Integer serialNumber = null;
    private static int lastUsedSerialNumber = 1;
    protected List<CyNode> nodeMapping;
    protected WeakReference<CyNetwork> networkRef;
    protected WeakReference<CyNetworkView> networkViewRef;
    protected JPopupMenu clusterPopup;
    protected AbstractAction copyToClipboardAction;
    protected AbstractAction extractClusterAction;
    protected AbstractAction saveClusterAction;
    protected AbstractAction removeClusterAction;
    protected AbstractAction saveClusterAsCyGroupAction;
    protected ShowDetailedResultsAction showDetailedResultsAction;

    public CytoscapeResultViewerPanel(ClusterONECytoscapeApp app, CyNetwork network) {
        this.app = app;
        this.networkRef = new WeakReference<CyNetwork>(network);
        this.initializeClusterPopup();
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CytoscapeResultViewerPanel.this.extractClusterAction.actionPerformed(null);
                }
            }
        });
        app.registerService(this, NetworkViewAddedListener.class);
        app.registerService(this, NetworkViewAboutToBeDestroyedListener.class);
        this.table.addMouseListener(new PopupMenuTrigger(this.clusterPopup));
        this.addAction(new FindAction(this));
        this.addAction(new SaveClusteringAction(this));
        this.addAction(new CloseAction(this));
        this.showDetailedResultsAction.setIconURL(app.getResource(app.getResourcePathName() + "/details.png"));
    }

    public CytoscapeResultViewerPanel(ClusterONECytoscapeApp app, CyNetworkView networkView) {
        this(app, (CyNetwork)networkView.getModel());
        this.setNetworkView(networkView);
    }

    public ClusterONECytoscapeApp getCytoscapeApp() {
        return this.app;
    }

    public CyNetwork getNetwork() {
        if (this.networkRef == null) {
            return null;
        }
        return (CyNetwork)this.networkRef.get();
    }

    public CyNetworkView getNetworkView() {
        if (this.networkViewRef == null) {
            return null;
        }
        return (CyNetworkView)this.networkViewRef.get();
    }

    public List<CyNode> getNodeMapping() {
        return this.nodeMapping;
    }

    public List<CyNode> getSelectedCytoscapeNodeSet() {
        TreeSet<Integer> selectedIndices = new TreeSet<Integer>();
        for (NodeSet selectedNodeSet : this.getSelectedNodeSets()) {
            for (Integer idx : selectedNodeSet) {
                selectedIndices.add(idx);
            }
        }
        return this.convertIterableToCytoscapeNodeList(selectedIndices);
    }

    public List<List<CyNode>> getSelectedCytoscapeNodeSets() {
        ArrayList<List<CyNode>> result = new ArrayList<List<CyNode>>();
        for (NodeSet selectedNodeSet : this.getSelectedNodeSets()) {
            result.add(this.convertIterableToCytoscapeNodeList(selectedNodeSet));
        }
        return result;
    }

    public List<List<CyNode>> getAllCytoscapeNodeSets() {
        NodeSetTableModel model = this.getTableModel();
        int numRows = model.getRowCount();
        ArrayList<List<CyNode>> result = new ArrayList<List<CyNode>>();
        for (int i = 0; i < numRows; ++i) {
            result.add(this.convertIterableToCytoscapeNodeList(model.getNodeSetByIndex(i)));
        }
        return result;
    }

    protected void setNetworkView(CyNetworkView networkView) {
        if (networkView == null) {
            this.networkViewRef = null;
            return;
        }
        if (networkView.getModel() != this.getNetwork()) {
            throw new RuntimeException("network view is associated to a different network");
        }
        this.networkViewRef = new WeakReference<CyNetworkView>(networkView);
    }

    public void addToCytoscapeResultPanel() {
        if (this.serialNumber == null) {
            this.serialNumber = lastUsedSerialNumber;
            ++lastUsedSerialNumber;
        }
        this.app.registerService(this, CytoPanelComponent.class);
        CytoPanel cytoPanel = this.app.getCySwingApplication().getCytoPanel(this.getCytoPanelName());
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        this.setVisible(true);
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent(this.getComponent()));
    }

    @Override
    protected Icon constructProgressIcon() {
        URL url = this.app.getResource(this.app.getResourcePathName() + "/wait.jpg");
        return url != null ? new ImageIcon(url) : new EmptyIcon(32, 32);
    }

    @Override
    protected ShowDetailedResultsAction constructShowDetailedResultsAction() {
        this.showDetailedResultsAction = super.constructShowDetailedResultsAction();
        return this.showDetailedResultsAction;
    }

    protected List<CyNode> convertIterableToCytoscapeNodeList(Iterable<Integer> iterable) {
        ArrayList<CyNode> result = new ArrayList<CyNode>();
        for (int idx : iterable) {
            CyNode node = this.nodeMapping.get(idx);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public void close() {
        this.app.unregisterService(this, CytoPanelComponent.class);
        CytoPanel cytoPanel = this.app.getCySwingApplication().getCytoPanel(this.getCytoPanelName());
        if (cytoPanel.getCytoPanelComponentCount() == 0) {
            cytoPanel.setState(CytoPanelState.HIDE);
        }
    }

    private void initializeClusterPopup() {
        this.clusterPopup = new JPopupMenu();
        this.copyToClipboardAction = new CopyClusterToClipboardAction(this);
        this.copyToClipboardAction.setEnabled(false);
        this.clusterPopup.add(this.copyToClipboardAction);
        this.extractClusterAction = new ExtractClusterAction(this);
        this.extractClusterAction.setEnabled(false);
        this.clusterPopup.add(this.extractClusterAction);
        this.saveClusterAction = new SaveClusterAction(this);
        this.saveClusterAction.setEnabled(false);
        this.clusterPopup.add(this.saveClusterAction);
        this.removeClusterAction = new RemoveClusterFromResultAction(this);
        this.removeClusterAction.setEnabled(false);
        this.clusterPopup.add(this.removeClusterAction);
    }

    public void selectNodes(Collection<? extends CyNode> nodes) {
        this.selectNodes(nodes, true);
    }

    public void selectNodes(Collection<? extends CyNode> nodes, boolean redraw) {
        CyNetwork network = this.getNetwork();
        if (network == null) {
            return;
        }
        CyNetworkUtil.unselectAllNodes(network);
        CyNetworkUtil.unselectAllEdges(network);
        CyNetworkUtil.setSelectedState(network, nodes, true);
        CyNetworkUtil.setSelectedState(network, CyNetworkUtil.getConnectingEdges(network, nodes), true);
        CyNetworkView networkView = this.getNetworkView();
        if (networkView != null) {
            networkView.updateView();
        }
    }

    public void setNodeMapping(List<CyNode> mapping) {
        this.nodeMapping = mapping;
    }

    public void setResult(ClusterONECytoscapeTask.Result result) {
        this.setNodeSets(result.clusters);
        this.setNodeMapping(result.nodeMapping);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        CyNetwork network = this.getNetwork();
        if (network == null) {
            this.copyToClipboardAction.setEnabled(false);
            this.extractClusterAction.setEnabled(false);
            this.saveClusterAction.setEnabled(false);
            return;
        }
        List<CyNode> nodes = this.getSelectedCytoscapeNodeSet();
        this.selectNodes(nodes);
        boolean enabled = nodes.size() > 0;
        this.extractClusterAction.setEnabled(enabled);
        this.copyToClipboardAction.setEnabled(enabled);
        this.saveClusterAction.setEnabled(enabled);
        this.removeClusterAction.setEnabled(enabled);
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.EAST;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "ClusterONE result " + this.serialNumber;
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent event) {
        if (this.getNetworkView() != event.getNetworkView()) {
            return;
        }
        this.setNetworkView(null);
    }

    public void handleEvent(NetworkViewAddedEvent event) {
        if (this.getNetworkView() != null) {
            return;
        }
        CyNetworkView newNetworkView = event.getNetworkView();
        if (this.getNetwork() != null && newNetworkView != null && newNetworkView.getModel() == this.getNetwork()) {
            this.setNetworkView(newNetworkView);
        }
    }

    class CloseAction
    extends AbstractAction {
        CytoscapeResultViewerPanel panel;

        public CloseAction(CytoscapeResultViewerPanel panel) {
            super("Close");
            this.panel = panel;
            this.putValue("ShortDescription", "Close this result panel");
            URL url = CytoscapeResultViewerPanel.this.app.getResource(CytoscapeResultViewerPanel.this.app.getResourcePathName() + "/close.png");
            if (url != null) {
                this.putValue("SmallIcon", new ImageIcon(url));
            }
        }

        public void actionPerformed(ActionEvent event) {
            this.panel.close();
        }
    }
}

