/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import uk.ac.rhul.cs.cl1.AbstractNodeSetMerger;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.SimilarityFunction;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSetList;
import uk.ac.rhul.cs.graph.BreadthFirstSearch;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.utils.Multiset;
import uk.ac.rhul.cs.utils.TreeMultiset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePassNodeSetMerger
extends AbstractNodeSetMerger {
    @Override
    public ValuedNodeSetList mergeOverlapping(ValuedNodeSetList nodeSets, SimilarityFunction<NodeSet> similarityFunc, double threshold) {
        int i;
        int n = nodeSets.size();
        long stepsTotal = n * (n - 1) / 2;
        long stepsTaken = 0L;
        ValuedNodeSetList result = new ValuedNodeSetList();
        if (n == 0) {
            return result;
        }
        Graph graph = ((ValuedNodeSet)nodeSets.get(0)).getGraph();
        Graph overlapGraph = new Graph();
        overlapGraph.createNodes(n);
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Finding highly overlapping clusters...");
        }
        for (i = 0; i < n; ++i) {
            NodeSet v1 = (NodeSet)nodeSets.get(i);
            for (int j = i + 1; j < n; ++j) {
                if (!(similarityFunc.getSimilarity(v1, (NodeSet)nodeSets.get(j)) >= threshold)) continue;
                overlapGraph.createEdge(i, j);
            }
            if ((stepsTaken += (long)(n - i - 1)) > stepsTotal) {
                stepsTaken = stepsTotal;
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted((int)(100.0f * ((float)stepsTaken / (float)stepsTotal)));
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Merging highly overlapping clusters...");
        }
        boolean[] visited = new boolean[n];
        Arrays.fill(visited, false);
        for (i = 0; i < n; ++i) {
            while (i < n && visited[i]) {
                ++i;
            }
            if (i == n) break;
            if (overlapGraph.getDegree(i) == 0) {
                result.add(nodeSets.get(i));
                visited[i] = true;
                continue;
            }
            BreadthFirstSearch bfs = new BreadthFirstSearch(overlapGraph, i);
            TreeMultiset<Integer> members = new TreeMultiset<Integer>();
            Iterator i$ = bfs.iterator();
            while (i$.hasNext()) {
                int j = (Integer)i$.next();
                SortedSet<Integer> newMembers = ((ValuedNodeSet)nodeSets.get(j)).getMembers();
                members.addAll(newMembers);
                nodeSets.set(j, null);
                visited[j] = true;
            }
            ValuedNodeSet newNodeSet = new ValuedNodeSet(graph, members.elementSet());
            for (Multiset.Entry entry : members.entrySet()) {
                newNodeSet.setValue((Integer)entry.getElement(), entry.getCount());
            }
            result.add(newNodeSet);
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted(100 * i / n);
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(100);
        }
        return result;
    }
}

