% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_Daybreak2R.R
\name{read_Daybreak2R}
\alias{read_Daybreak2R}
\title{Import measurement data produced by a Daybreak TL/OSL reader into R}
\usage{
read_Daybreak2R(file, raw = FALSE, verbose = TRUE, txtProgressBar = TRUE)
}
\arguments{
\item{file}{\link{character} or \link{list} (\strong{required}):
path and file name of the file to be imported. Alternatively a list of file
names can be provided or just the path a folder containing measurement data.
Please note that the specific, common, file extension (txt) is likely
leading to function failures during import when just a path is provided.}

\item{raw}{\link{logical} (\emph{with default}):
if the input is a DAT-file (binary) a \link[data.table:data.table]{data.table::data.table} instead of
the \linkS4class{RLum.Analysis} object can be returned for debugging purposes.}

\item{verbose}{\link{logical} (\emph{with default}):
enables or disables terminal feedback}

\item{txtProgressBar}{\link{logical} (\emph{with default}):
enables or disables \link{txtProgressBar}.}
}
\value{
A list of \linkS4class{RLum.Analysis} objects (each per position) is provided.
}
\description{
Import a TXT-file (ASCII file) or a DAT-file (binary file) produced by a
Daybreak reader into R. The import of the DAT-files is limited to the file
format described for the software TLAPLLIC v.3.2 used for a Daybreak, model 1100.
}
\note{
\strong{\verb{[BETA VERSION]}}
This function still needs to be tested properly. In particular
the function has underwent only very rough rests using a few files.
}
\section{Function version}{
 0.3.1
}

\examples{

\dontrun{
file <- file.choose()
temp <- read_Daybreak2R(file)
}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}, \link[data.table:data.table]{data.table::data.table}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)\cr
Anotine Zink, C2RMF, Palais du Louvre, Paris (France)

The ASCII-file import is based on a suggestion by Willian Amidon and Andrew Louis Gorin
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., Zink, A., 2020. read_Daybreak2R(): Import measurement data produced by a Daybreak TL/OSL reader into R. Function version 0.3.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.8. https://r-luminescence.org
}

\keyword{IO}
