% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_RLum.R
\name{get_RLum}
\alias{get_RLum}
\alias{get_RLum,list-method}
\alias{get_RLum,NULL-method}
\title{General accessors function for RLum S4 class objects}
\usage{
get_RLum(object, ...)

\S4method{get_RLum}{list}(object, class = NULL, null.rm = FALSE, ...)

\S4method{get_RLum}{`NULL`}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum} or an object of type \link{list} containing only objects
of type \linkS4class{RLum}}

\item{...}{further arguments that will be passed to the object specific methods. For
further details on the supported arguments please see the class
documentation: \linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum},
\linkS4class{RLum.Data.Image}, \linkS4class{RLum.Analysis} and \linkS4class{RLum.Results}}

\item{class}{\link{character} (\emph{optional}): allows to define the class that gets selected if
applied to a list, e.g., if a list consists of different type of RLum-class objects, this
arguments allows to make selection. If nothing is provided, all RLum-objects are treated.}

\item{null.rm}{\link{logical} (\emph{with default}): option to get rid of empty and NULL objects}
}
\value{
Return is the same as input objects as provided in the list.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding get function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum} class.
}
\section{Functions}{
\itemize{
\item \code{get_RLum(list)}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{get_RLum}

\item \code{get_RLum(`NULL`)}: Returns NULL

}}
\section{Function version}{
 0.3.3
}

\examples{

##Example based using data and from the calc_CentralDose() function

##load example data
data(ExampleData.DeValues, envir = environment())

##apply the central dose model 1st time
temp1 <- calc_CentralDose(ExampleData.DeValues$CA1)

##get results and store them in a new object
temp.get <- get_RLum(object = temp1)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2023. get_RLum(): General accessors function for RLum S4 class objects. Function version 0.3.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.21. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
