




<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

## Changes in version 0.9.2 (2019-07-30)

  - Fix an URL problem discovered by the CRAN precheck

## Changes in version 0.9.1 (2019-07-30) - never released on CRAN

### Removed functions

  - `model_LuminescenceSignals()`: This wrapper function for the R
    package ‘RLumModel’ was removed due to changes on CRAN inflicting a
    warning ‘object is masked from ’package:Luminescence’ each time
    ‘RLumModel was loaded. In ’Luminescence’ the function had no real
    scope, but provided a place holder to point the users on the
    existence of the package ‘RLumModel’.

### Bugfixes and changes

#### `apply_EfficiencyCorrection()`

  - The function now suppors `RLum.Analysis` objects as input
  - All allowed input objects can now be provided as `list` (self-call
    support)
  - Minor code polish

#### `analyse_baSAR()`

  - The manual stated that `RLum.Analysis-class` are supported, but
    actually this is not true, it supports a list of `RLum.Analysis`
    objects only.
  - Some minor manual corrections.

#### `analyse_SAR.CWOLS()`

  - Add support for `POSL` data,before the function crashed (reported by
    Alice Versendaal). `POSL` curves had been not listed as supported
    curve types though.
  - Improve dataset recognition (`OSL`, `IRSL`, `POSL`).

#### `calc_Lamothe2003()`

  - The documentation wrongly stated that an input `data.frame` should
    have the columns ‘dose’, ‘De’ and ‘De error’, indeed ‘dose’, ‘LxTx’
    and ‘LxTx error’ are expected (spotted by Jeong-Heon Choi)

#### `calc_TLLxTxRatio()`

  - The `LxTx.Error` is no longer negative, even if the subtration lead
    to negative count values (\#78, reported by Sébastian Huot)

#### `calc_SourceDoseRate()`

  - The function learned about the half-life of Cs-137

#### `fit_OSLLifeTimes()`

  - `0` count values crashed the function for obvious reasons (`a / 0 =
    Inf`), this can happen in particular for artificial datasets. Now,
    if `0` is detected, count values are increased by `0.1` (reported by
    Dirk Mittelstrass)

#### `plot_AbanicoPlot()`

  - If `summary = "se.abs"` was chosen, the abanico plot showed `se.rel`
    instead; corrected (reported by Maryam Heydari)

#### `plot_DRTResults()`

  - Correct documentation, where it was erroneously implicated that the
    `...` argument pipes all arguments,
  - add support for argument `las`.

#### `plot_GrowthCurve()`

  - If the dose points included `NA` values the function crashed
    unexpectetly.

#### S4-classes and methods

  - `RLum.Analysis-class`
      - Code polish (no visible changes)
  - `RLum.Data.Curve-class`
      - Code polish and clearifying the documentation
  - `RLum.Data.Image-class`
      - Conversion methods to a `matrix` and from and to `data.frame`
        never worked as intended.
      - Code housekeeping

#### Internals

  - The ‘DESCRIPTION’ file contained the string “\[upcoming\]”. This was
    a left-over from the development version and is now removed.

  - Version numbering is now again more R canonical consisting only of
    three numbers (‘stable.major.minor’). Development versions are only
    indicated by `.9000` in the version number. Numbers after `9000`
    (e.g., `9000-1`) indicate build numbers. Both is used for GitHub
    build versions only.

  - The file name `RisoeBINfileData-class.R` was changed to
    `Risoe.BINfileData-class.R` for consistency reasons, however, this
    has no furhter visible effect (\#76, spotted by Sébastien Huot)

## Changes in version 0.9.0.110 (2019-04-21)

‘Luminescence’ 0.9.X releases will be the last versions supporting **R**
\< 3.5.0.

### Important R related changes (R \>= 3.6.0)

The behaviour of the base R function `sample()` was changed / corrected
(see news on <https://r-project.org> for details). This function is used
heavily within functions by ‘Luminescence’ (e.g., `plot_GrowthCurve()`).
That being said, it means that old data re-analysed by ‘Luminescence’
using R versions \>= 3.6.0 will not give the same results. Differences
are small, however, they may significant. If you want to reproduce your
data, we recommend to use one of our [Docker
images](https://github.com/R-Lum/RLumDocker) which include the R version
from the package release date.

### New functions

  - `convert_Wavelength2Energy()` Smooth and quick emission spectra
    conversion from wavelength to energy scales
  - `fit_OSLLifeTimes()` Fit and deconvolution of OSL lifetimes using
    off-time measurements, i.e. after the stimulation was switched off.
  - `plot_DRCSummary()` Summarise all dose-response curves from your SAR
    OSL analysis in one single plot.
  - `scale_GammaDose()` Scale the gamma dose rate considering
    layer-to-layer variations in soil radioactivity. Contributed by S.
    Riedesel and M. Autzen.
  - `fit_ThermalQuenching()` Provide an easy option to fit thermal
    quenching data and determine the activation energy.

### Bugfixes and changes

#### `apply_CosmicRayRemoval()`

  - Thanks to black magic, this function now runs also over a list of
    `RLum.Data.Spectrum` objects and and `RLum.Analysis` objects (also
    nested in a list)

#### `apply_EfficiencyCorrection()`

  - The function produced a warning (“collapsing to unique ‘x’ values”)
    on R-devel; fixed.

#### `analyse_SAR.CWOSL()`

  - If the function was used in a self-call mode (object of type
    `list`), the arguments contrary to what is written in the manual,
    the arguments such as `signal.integral.min` had not been expanded
    properly; no one complained, however, corrected.
  - The argument `main` no also supports the input `list` in the
    self-call mode.

#### `analyse_SAR.TL()`

  - The plot legend was not correct, if no dose points had been
    provided; fixed
  - The function returned a confusion warning; fixed.
  - If background signals are provided, now the background subtracted
    signal is shown automatically instead of the uncorrected curves
    (suggestion by Tilmann Wolpert)
  - The function now supports a list of `RLum.Analysis` objects as input
  - The plot settings were sufficiently reset; fixed.
  - Code polish

#### `analyse_FadingMeasurements()`

  - Enable support for data imported from a BIN/BINX-file
  - If the g-value is negative, now it also returns a negative g-value;
    before always the absolute values was taken, which was not
    meaningful
  - If rho was negative, the log10 value could not be calculated, this
    caused an unwanted warning; now suppressed
  - It showed a warning on R-devel due to changes in `stats::approx()`;
    fixed
  - Records with negative ‘time since irradiation’ are now automatically
    removed (thanks to input by Sébastien Huot)
  - Function is now more relaxed when odd data a provided and it is less
    talkative

#### `calc_Huntley2006()`

  - The function now checks if rho’ (`rhop`) is a sensible non-zero
    positive value and, if otherwise, stops with a more meaningful error
    message. (Issue \#74)
  - Now the function is a little bit less talkative if extreme dataset
    are provided as input

#### `read_BIN2R()`

  - Add support for missing BINX-file version 5 (pointed out by Harrison
    Gray)
  - In the auto-file recognition (only a path instead of a file is
    provided), sometimes the found BIN/BINX-files were imported twice.
    The corresponding code was simplified to avoid such errors in future
  - Sometimes the time stamp is invalid since it is missing a leading
    `0`. For BINX-files \>= version 6 such timestamps now get corrected
    during the import

#### `read_XSYG2R()`

  - The function failed for R-devel importing spectrometer data
    (`approx(..., ties = -2)`); fixed.

#### `plot_GrowthCurve()`

  - The function crashed with `Error in data.MC[, i] : incorrect number
    of dimensions` under very particular circumstances (reported by
    Alice Versendaal). This was due to unwanted internal object
    conversion; fixed.

#### `plot_RLum.Data.Spectrum()`

  - The wavelength to energy scale conversion was not correct. This was
    corrected and internally, the function now calls consistently the
    new function `convert_Wavelength2Enegy()` (the corresponding code
    and documentation have been updated or removed).  
  - The function gained a new argument `norm` for normalising the data
    to the highest or the lowest count value.
  - The function gained a new argument `bg.spectrum` allow to pass a
    background spectrum that can be used for the subtraction
  - The function returned a warning if a single matrix was used but
    `plot.type` was already set to `single`; fixed.
  - Wrong settings in `bg.channels` crashed the function. Now it
    auto-corrects the wrong values.
  - Channel binning now consistently calls the internal function
    `Luminescence:::.matrix_binning()`, which is more efficient cleaner
    than the code used before
  - The function now longer crashes for `plot.type = 'persp'` if
    ’xaxis.energy = TRUE\`.
  - The colour picking option was not always working; fixed.
  - Warnings are formatted more nicely.

#### `verify_SingeGrainData()`

  - The function crashed for crazy datasets; fixed
  - Cleaning-up `RLum.Analysis-class` objects did not worked; fixed

#### `write_RLum2CSV()`

  - The function gained a new argument `compact` which is set `TRUE` be
    default, and keeps the element output as simple as possible, which
    is in particular helpful for `RLum.Results` objects
  - The function now behaves more friendly to `RLum.Results` objects,
    before the output was hard to understand.

#### `write_RLum2BIN()`

  - The export failed if the time stamp was invalid (`NA`); now `NA`
    values are consistently replaced by `000000` (other values are not
    possible, otherwise the re-import of such file would fail) (reported
    by Alice Versendaal via email, 2019-03-06)

### Changes in S4-objects and methods

#### `get_RLum`

  - The method working on `list` elements got a new argument `class` to
    remove unwanted `RLum` objects in from list of `RLum` objects

#### `RLum.Analysis-class`

  - The show-method crashed under very rare circumstances if
    inconsistent objects had been combined; fixed.

#### `RLum.Data.Spectrum-class`

  - Support added for `bin_RLum.Data()`

### New example datasets

  - `ExampleData.TR_OSL` provides a single fast-pulsing OSL curve that
    can be used to test the function `fit_OSLLifeTimes()`.

### Internals

  - Package news are now provided as markdown document (NEWS.md) which
    is supported by CRAN
  - The package version numbering scheme has been modified to simplify
    the distinction between different developer versions. While relevant
    numbers for CRAN remain X.X.X, which reads ‘stable.major.minor’
    version, a 4th number indicates the running package build number,
    e.g., 0.9.0.7.
  - New internal function `Luminescence:::.matrix_binning()` to get the
    matrix (and curve) binning consistent; so far used only by the the
    `bin_RLum.Data()` method for `RLum.Data.Spectrum-class`
  - Vignette S4-class object structure updated
  - Internal changes to address changes in R-devel checking logical
    arguments with length more than one (e.g., `if(is.na(x))` returned
    an error if `x` was not a vector of length 1)
  - `src/Makevars` file removed to prevent unconditional stripping in
    response to a recent CRAN request; in return the installation size
    of the package increased in size on some platforms.
