% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_DRAC.R
\name{template_DRAC}
\alias{template_DRAC}
\title{Create a DRAC input data template (v1.1)}
\usage{
template_DRAC(nrow = 1, notification = TRUE)
}
\arguments{
\item{nrow}{\code{\link{integer}} (with default): specifies the number of rows
of the template (i.e., the number of data sets you want to submit)}

\item{notification}{\code{\link{logical}} (with default): show or hide the
notification}
}
\value{
A list.
}
\description{
This function returns a DRAC input template (v1.1) to be used in conjunction
with the use_DRAC() function
}
\examples{

# create a new DRAC input input
input <- template_DRAC()

# show content of the input
print(input)
print(input$`Project ID`)
print(input[[4]])


## Example: DRAC Quartz example
# note that you only have to assign new values where they 
# are different to the default values
input$`Project ID` <- "DRAC-Example"
input$`Sample ID` <- "Quartz"
input$`Conversion factors` <- "AdamiecAitken1998"
input$`External U (ppm)` <- 3.4
input$`errExternal U (ppm)` <- 0.51
input$`External Th (ppm)` <- 14.47
input$`errExternal Th (ppm)` <- 1.69
input$`External K (\%)` <- 1.2
input$`errExternal K (\%)` <- 0.14
input$`Calculate external Rb from K conc?` <- "N"
input$`Calculate internal Rb from K conc?` <- "N"
input$`Scale gammadoserate at shallow depths?` <- "N"
input$`Grain size min (microns)` <- 90
input$`Grain size max (microns)` <- 125
input$`Water content ((wet weight - dry weight)/dry weight) \%` <- 5
input$`errWater content \%` <- 2
input$`Depth (m)` <- 2.2
input$`errDepth (m)` <- 0.22
input$`Overburden density (g cm-3)` <- 1.8
input$`errOverburden density (g cm-3)` <- 0.1
input$`Latitude (decimal degrees)` <- 30.0000
input$`Longitude (decimal degrees)` <- 70.0000
input$`Altitude (m)` <- 150
input$`De (Gy)` <- 20
input$`errDe (Gy)` <- 0.2

# use DRAC
\dontrun{
output <- use_DRAC(input)
}

} 

\section{How to cite}{
Burow, C. (2017). template_DRAC(): Create a DRAC input data template (v1.1). In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.4. https://CRAN.R-project.org/package=Luminescence
}

\references{
Durcan, J.A., King, G.E., Duller, G.A.T., 2015. DRAC: Dose Rate and Age Calculator for trapped charge dating.
Quaternary Geochronology 28, 54-61. doi:10.1016/j.quageo.2015.03.012
}
\seealso{
\code{\link{as.data.frame}} \code{\link{list}}
}
\author{
Christoph Burow, University of Cologne (Germany)
}
