% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-confint.R
\name{confint.PLR_boot}
\alias{confint.PLR_boot}
\alias{confint.PLR}
\alias{confint.PLR_cv}
\title{Confidence intervals for the penalized Lorenz regression}
\usage{
\method{confint}{PLR_boot}(
  object,
  parm = c("Gini", "LR2"),
  level = 0.95,
  type = c("norm", "basic", "perc"),
  pars.idx = "BIC",
  bias.corr = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"PLR_boot"}. The object might also have S3 class \code{"PLR_cv"}. The current implementation requires bootstrap to construct confidence intervals. Hence, it is not sufficient that \code{object} inherits from \code{"PLR"}.}

\item{parm}{A character string determining whether the confidence interval is computed for the explained Gini coefficient or for the Lorenz-\eqn{R^2}. Possible values are \code{"Gini"} (default, for the explained Gini) and \code{"LR2"} (for the Lorenz-\eqn{R^2})}

\item{level}{A numeric giving the level of the confidence interval. Default value is 0.95.}

\item{type}{A character string specifying the bootstrap method. Possible values are \code{"norm"}, \code{"basic"} and \code{"perc"}. For more information, see the argument \code{type} of the function \code{\link[boot]{boot.ci}} from the \emph{boot} library.}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default).
   \item \code{"Boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{bias.corr}{A logical determining whether bias correction should be performed. Only used if \code{type="norm"}. Default is \code{TRUE}.}

\item{...}{Additional arguments.}
}
\value{
A vector providing the desired confidence interval.
}
\description{
Provides bootstrap confidence intervals for the explained Gini coefficient and Lorenz-\eqn{R^2} for an object of class \code{"PLR_boot"}.
}
\examples{
## For examples see example(Lorenz.boot)

}
\seealso{
\code{\link{Lorenz.boot}}, \code{\link[boot]{boot.ci}}
}
