% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logforest.R
\name{logforest}
\alias{logforest}
\title{Logic Forest}
\usage{
logforest(resp, Xs, nBSXVars, anneal.params, nBS=100, h=0.5, norm=TRUE, numout=5, nleaves)
}
\arguments{
\item{resp}{numeric vector of binary response values}

\item{Xs}{matrix or dataframe of zeros and ones for all predictor variables}

\item{nBSXVars}{integer for the number of predictors used to construct each logic regression model.  The default value is all predictors in the data.}

\item{anneal.params}{a list containing the parameters for simulated annealing.  See the help file for the function \code{logreg.anneal.control} in the \code{LogicReg} package.  If missing, default annealing parameters are set at \code{start}=1, \code{end}=-2, and \code{iter}=50000.}

\item{nBS}{number of logic regression trees to be fit in the logic forest model.}

\item{h}{a number between 0 and 1 for the minimum proportion of trees in the logic forest that must predict a 1 for the prediction to be one.}

\item{norm}{logical.  If FALSE, predictor and interaction scores in model output are not normalized to range between zero and one.}

\item{numout}{number of predictors and interactions to be included in model output}

\item{nleaves}{the maximum number of end nodes generated for each tree}
}
\value{
An object of class \code{"logforest"} including a list of values
}
\description{
Constructs an ensemble of logic regression models using bagging for classification and identification of important predictors and predictor interactions
}
