#' Internal Logic Forest Functions
#'
#' This function is called by \code{\link{logforest}}. It is not intended to be used independently of this function.
#' @returns No return value, called for side effects
#' @details
#' Determines the permutation based importance measure for all variables and variable interactions corresponding to a specific logic regression tree within a logic forest.
#'
#'
#' @export
#' @keywords internal

pimp.import<-function(fit, data, testdata, BSpred, pred, Xs, mtype)
{
  if (mtype=="Classification") {mtyp=1}
  if (mtype=="Linear Regression") {mtyp=2}
  n<-nrow(testdata) #number obs in testdata (OOB)
  tree<-fit$model$trees[[1]]
  y<-testdata[,(BSpred+1)]
  x.names<-colnames(data[,1:BSpred])
  orig.pred<-predict.logreg(fit, newbin=testdata[,1:BSpred])
  if (mtyp==1) {orig.miss<-sum(abs(orig.pred-y))/n}
  if (mtyp==2) {orig.miss<-log2(sum((orig.pred-y)^2)/n)}
  pimpinfo<-prime.imp(tree=tree, data=data, Xs=Xs, mtype=mtyp)
  Ipimat<-matrix(0, nrow=nrow(pimpinfo$tmp.mat), ncol=pred*2)
  for (i in 1:nrow(pimpinfo$tmp.mat))
  {
    lc<-pimpinfo$tmp.mat[i,][which(pimpinfo$tmp.mat[i,]!=0)]*pimpinfo$list.pimps[[i]]
    lc<-ifelse(lc>0, lc, -1*lc+pred)
    Ipimat[i,lc]<-1
  }
  colnames(Ipimat)<-c(x.names, paste("!", x.names, sep=""))
  vec.Xvars<-pimpinfo$vec.pimpvars
  nxvars<-length(vec.Xvars)
  single.vimp<-c()
  single.vimp.nms<-c()
  Xids<-c()
  for (i in 1:nxvars)#checking single var importance for tree
  {
    id<-vec.Xvars[i]
    Xid<-Xs[id]
    permute.ind<-sample(1:n, n, replace=FALSE)
    permute.col<-testdata[permute.ind, id]
    pre.id<-if(id>1) as.matrix(testdata[,1:(id-1)])
    post.id<-if(id<pred) as.matrix(testdata[,(id+1):BSpred])
    permute.testdata<-cbind(pre.id, permute.col, post.id)
    perm.pred<-predict.logreg(fit, newbin=as.matrix(permute.testdata[,1:BSpred]))
    if (mtyp==1) {perm.misclass<-sum(abs(perm.pred-y))/n}
    if (mtyp==2) {perm.misclass<-log2(sum((perm.pred-y)^2)/n)}
    vimp<-perm.misclass-orig.miss
    single.vimp<-append(single.vimp, vimp)
    single.vimp.nms<-append(single.vimp.nms, x.names[id])
    Xids<-append(Xids, Xid)
  }
  names(single.vimp)<-single.vimp.nms
  pimpmat<-pimp.mat(pimps.out=pimpinfo, testdata=testdata)[[2]] #transforms data into predictors = pimps
  pimpnames<-pimp.mat(pimps.out=pimpinfo, testdata=testdata)[[1]] #vector of pimp names
  tmp.mat<-pimpinfo$tmp.mat
  zero.ids<-c()
  for(i in 1:ncol(tmp.mat))
  {
    ids<-if(all(tmp.mat[,i]==0)) {ids<-i}
    zero.ids<-append(zero.ids, ids)
  }
  if (length(zero.ids) > 0) {tmp.mat<-tmp.mat[,-zero.ids]}
  if (is.matrix(tmp.mat)) {npimps<-nrow(tmp.mat)}
  if (is.vector(tmp.mat)) {npimps<-1}
  pimp.vimp<-c()
  for (j in 1:npimps)
  {
    perm.ind<-sample(1:n, n, replace=FALSE)
    perm.col<-pimpmat[perm.ind, j]
    pre.j<-if(j>1) pimpmat[,1:(j-1)]
    post.j<-if(j<npimps) pimpmat[,(j+1):npimps]
    permute.pimpdata<-cbind(pre.j, perm.col, post.j)
    pimp.pred<-c()
    for (k in 1:n)
    {
      if(mtyp==1)
      {
        pred<-ifelse(any(permute.pimpdata[k,]==1), 1, 0)
        pimp.pred<-append(pimp.pred, pred)
      }
      if(mtyp==2)
      {
        pred<-ifelse(any(permute.pimpdata[k,]==1), sum(fit$model$coef), fit$model$coef[1])
        pimp.pred<-append(pimp.pred, pred)
      }
    }
    if (mtyp==1) {permpimp.miss<-sum(abs(pimp.pred-y))/n}
    if (mtyp==2) {permpimp.miss<-log2(sum((pimp.pred-y)^2)/n)}
    pvimp<-permpimp.miss-orig.miss #diff bt/ permutation and original
    pimp.vimp<-append(pimp.vimp, pvimp)
  }
  names(pimp.vimp)<-paste(pimpnames)
  out<-list(single.vimp=single.vimp, pimp.vimp=pimp.vimp, Ipimat=Ipimat, vec.Xvars=vec.Xvars, Xids=Xids)
}
