% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{UPSboxplot}
\alias{UPSboxplot}
\title{Returns a series of boxplots comparing LTD distributions given different numbers of clusters.}
\usage{
UPSboxplot(envir, clusterSubset = c())
}
\arguments{
\item{envir}{A LocalControlClassic environment containing UPSnnltd objects.}

\item{clusterSubset}{(optional) A vector containing requested cluster counts.
If provided, the boxplot is created using only the UPSnnltd objects corresponding to the requested cluster counts.}
}
\value{
Returns the call to boxplot with the formula: "ltd ~ numclst".

Adds the "ltdds" object to the Local Control environment.
}
\description{
Given the output of \code{\link{LocalControlClassic}}, this function uses all or some of the
UPSnnltd objects contained to create a series of boxplots of the local treatment difference at each of the
different numbers of requested clusters.
}
\examples{

data(lindner)
cvars <- c("stent","height","female","diabetic","acutemi",
           "ejecfrac","ves1proc")
numClusters <- c(1, 5, 10, 20, 40, 50)

results <- LocalControlClassic(data = lindner,
                               clusterVars = cvars,
                               treatmentColName = "abcix",
                               outcomeColName = "cardbill",
                               clusterCounts = numClusters)

bxp <- UPSboxplot(results)

}
