% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{plot.LocalControlCS}
\alias{plot.LocalControlCS}
\title{Plots the local treatment difference as a function of radius for LocalControl.}
\usage{
\method{plot}{LocalControlCS}(
  x,
  ...,
  nnConfidence,
  ylim,
  legendLocation = "bottomleft",
  ylab = "LTD",
  xlab = "Fraction of maximum radius",
  main = ""
)
}
\arguments{
\item{x}{Return object from LocalControl with "default" outcomeType.}

\item{...}{
  Arguments passed on to \code{\link[graphics:plot.default]{graphics::plot}}
  \describe{
    \item{\code{}}{}
  }}

\item{nnConfidence}{Return object from LocalControlNearestNeighborsConfidence}

\item{ylim}{The y axis bounds. Defaults to c(0,1).}

\item{legendLocation}{The location to place the legend. Default "topleft".}

\item{ylab}{The y axis label. Defaults to "LTD".}

\item{xlab}{The x axis label. Defaults to "Fraction of maximum radius".}

\item{main}{The main plot title. Default is empty.}
}
\description{
Creates a plot where the y axis represents the local treatment difference,
while the x axis represents the percentage of the maximum radius. If the confidence summary (nnConfidence)
is provided, the 50\% and 95\% confidence estimates are also plotted.
}
\examples{
data(lindner)
# Specify clustering variables.
linVars <- c("stent", "height", "female", "diabetic",
             "acutemi", "ejecfrac", "ves1proc")

# Call Local Control once.
linRes <- LocalControl(data = lindner,
                       clusterVars = linVars,
                       treatmentColName = "abcix",
                       outcomeColName = "cardbill",
                       treatmentCode = 1)

# Plot the local treatment differences from Local Control without
# confidence intervals.
plot(linRes, ylim =  c(-6000, 3600))

#If the confidence intervals are calculated:
#linConfidence = LocalControlNearestNeighborsConfidence(
#                                      data = lindner,
#                                      clusterVars = linVars,
#                                      treatmentColName = "abcix",
#                                      outcomeColName = "cardbill",
#                                      treatmentCode = 1, nBootstrap = 100)

# Plot the local treatment difference with confidence intervals.
#plot(linRes, linConfidence)

}
\references{
\itemize{
   \item Lauve NR, Nelson SJ, Young SS, Obenchain RL, Lambert CG. LocalControl: An R Package for Comparative Safety and Effectiveness Research. Journal of Statistical Software. 2020. p. 1–32. Available from: http://dx.doi.org/10.18637/jss.v096.i04
}
}
