% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_consensus_taxonomy.R
\name{get_consensus_taxonomy}
\alias{get_consensus_taxonomy}
\title{Get Consensus Taxonomy from Taxonomic Strings}
\usage{
get_consensus_taxonomy(taxonomies, full_names = TRUE, delimiter = ";")
}
\arguments{
\item{taxonomies}{A character vector of taxonomic strings.}

\item{full_names}{Logical. If \code{TRUE} (the default), then the full consensus taxonomy is returned. If \code{FALSE}, then only the lowest taxonomic level of the consensus taxonomy is returned.}

\item{delimiter}{A character string of the delimiter between taxonomic levels in the input taxonomies. The default is \code{";"}.}
}
\value{
A character string containing the taxonomy agreed upon by all input taxonomies. If the input taxonomies are not the same at any taxonomic level, then \code{NA} is returned.
}
\description{
Gets the consensus taxonomy from a vector of taxonomic strings.
}
\examples{
get_consensus_taxonomy(taxonomies=
   c("Eukaryota;Chordata;Amphibia;Caudata;Ambystomatidae;Ambystoma;Ambystoma_mavortium",
     "Eukaryota;Chordata;Amphibia;Anura;Bufonidae;Anaxyrus;Anaxyrus_boreas",
     "Eukaryota;Chordata;Amphibia;Anura;Ranidae;Rana;Rana_luteiventris"),
                       full_names=TRUE,
                       delimiter=";")
}
