% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_test.R
\name{binomial_test}
\alias{binomial_test}
\title{Binomial Test}
\usage{
binomial_test(k, n, p, alternative = "greater")
}
\arguments{
\item{k}{A numeric vector of the number of successes.}

\item{n}{A numeric vector of the number of trials.}

\item{p}{A numeric vector of the hypothesized probabilities of success.}

\item{alternative}{A string specifying the alternative hypothesis. Must be \code{"less"} or \code{"greater"} (the default).}
}
\value{
A numeric vector of p-values from the binomial tests.
}
\description{
Performs binomial tests.
}
\details{
Calls on the \code{\link[stats:Binomial]{pbinom}} function in the \link[stats:stats-package]{stats} package to perform vectorized binomial tests. Arguments are recycled as in \code{\link[stats:Binomial]{pbinom}}. Only one-sided tests are supported, and only p-values are returned.
}
\examples{
binomial_test(k=c(5,1,7,4),
              n=c(10,3,15,5),
              p=c(0.2,0.1,0.5,0.6),
              alternative="greater")
}
