% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm.R
\name{ggm}
\alias{ggm}
\title{Linearized Bregman solver for composite conditionally likelihood of Gaussian Graphical
 model with lasso penalty.}
\usage{
ggm(X, kappa, alpha, S = NA, c = 2, tlist, nt = 100, trate = 100,
  print = FALSE)
}
\arguments{
\item{X}{An n-by-p matrix of variables.}

\item{kappa}{The damping factor of the Linearized Bregman Algorithm that is
defined in the reference paper. See details.}

\item{alpha}{Parameter in Linearized Bregman algorithm which controls the 
step-length of the discretized solver for the Bregman Inverse Scale Space. 
See details.}

\item{S}{The covariance matrix can be provided directly if data matrix X is missing.}

\item{c}{Normalized step-length. If alpha is missing, alpha is automatically generated by 
\code{alpha=c*n/(kappa*||X^T*X||_2)}. Default is 2. It should be in (0,4).
If beyond this range the path may be oscillated at large t values.}

\item{tlist}{Parameters t along the path.}

\item{nt}{Number of t. Used only if tlist is missing. Default is 100.}

\item{trate}{tmax/tmin. Used only if tlist is missing. Default is 100.}

\item{print}{If TRUE, the percentage of finished computation is printed.}
}
\value{
A "ggm" class object is returned. The list contains the call, 
 the path, value for alpha, kappa, t.
}
\description{
Solver for the entire solution path of coefficients.
}
\details{
The data matrix X is assumed to follow the Gaussian Graohical model which is described as following:\cr
\deqn{X \sim N(\mu, \Theta^{-1})}\cr
where \eqn{\Theta} is sparse p-by-p symmetric matrix. Then conditional on \eqn{x_{-j}}\cr
\deqn{x_j \sim N(\mu_j - \sum_{k\neq j}\Theta_{jk}/\Theta_{jj}(x_k-\mu_k),1/\Theta_{jj}) }\cr
then the composite conditional likelihood is like this:\cr
\deqn{- \sum_{j} condloglik(X_j | X_{-j})}\cr
or in detail:\cr
\deqn{\sum_{j} \Theta_{j}^TS\Theta_{j}/2\Theta_{jj} - ln(\Theta_{jj})/2}\cr
where \eqn{S} is covariance matrix of data. It is easy to prove that this loss function
is convex.
}
\examples{

library(MASS)
p = 20
Omega = diag(1,p,p)
Omega[0:(p-2)*(p+1)+2] = 1/3
Omega[1:(p-1)*(p+1)] = 1/3
S = solve(Omega)
X = mvrnorm(n=500,rep(0,p),S)
obj = ggm(X,10,trate=10)
obj$path[,,50]
}
\author{
Jiechao Xiong
}
\keyword{regression}

