% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.LiblineaR.ACF}
\alias{predict.LiblineaR.ACF}
\title{Predictions with LiblineaR.ACF model}
\usage{
\method{predict}{LiblineaR.ACF}(object, newx, decisionValues = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{"LiblineaR.ACF"}, created by
\code{LiblineaR.ACF}.}

\item{newx}{An n x p matrix containing the new input data. A vector will be
transformed to a n x 1 matrix. A sparse matrix (from SparseM package) will
also work.}

\item{decisionValues}{Logical indicating whether model decision values should
be computed and returned. Default is \code{FALSE}.}

\item{...}{Currently not used}
}
\value{
By default, the returned value is a list with a single entry:
\item{predictions}{A vector of predicted labels.}
If \code{decisionValues} is set to \code{TRUE}, an additional entry is returned:
\item{decisionValues}{An n x k matrix (k number of classes) of the model
  decision values. The columns of this matrix are named after class labels.}
}
\description{
The function applies a classification model produced by the \code{LiblineaR.ACF} function to every row of a
data matrix and returns the model predictions.
}
\note{
If the data on which the model has been fitted have been centered
  and/or scaled, it is very important to apply the same process on the
  \code{newx} data as well, with the scale and center values of the training
  data.
}
\author{
Thibault Helleputte \email{thibault.helleputte@dnalytics.com} and 
  Pierre Gramme \email{pierre.gramme@dnalytics.com}.\cr 
  Modified by Aydin Demircioglu.\cr
  Based on C/C++-code by Chih-Chung Chang and Chih-Jen Lin
}
\references{
\itemize{
\item 
For more information on LIBLINEAR itself, refer to:\cr
R.-E. Fan, K.-W. Chang, C.-J. Hsieh, X.-R. Wang, and C.-J. Lin.\cr
\emph{LIBLINEAR: A Library for Large Linear Classification,}\cr
Journal of Machine Learning Research 9(2008), 1871-1874.\cr
\url{http://www.csie.ntu.edu.tw/~cjlin/liblinear}
}
}
\seealso{
\code{\link{LiblineaR.ACF}}
}
\keyword{classes}
\keyword{classif}
\keyword{models}
\keyword{multivariate}
\keyword{optimize}

