% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Correlation.R
\name{Correlation}
\alias{Correlation}
\alias{association.corr}
\title{Test for Association Between Paired Samples}
\description{
Performs correlation coefficient based two-sample association test on samples.
}
\examples{
pmt(
    "association.corr", method = "pearson",
    alternative = "greater", n_permu = 10000
)$test(Table5.1.2)$print()

t <- pmt(
    "association.corr", method = "spearman",
    alternative = "two_sided", n_permu = 10000
)$test(Table5.1.2)$print()

t$type <- "asymp"
t

t <- pmt(
    "association.corr", method = "kendall",
    alternative = "greater", n_permu = 0
)$test(Table5.2.2)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:TwoSampleTest]{LearnNonparam::TwoSampleTest}} -> \code{\link[LearnNonparam:TwoSamplePairedTest]{LearnNonparam::TwoSamplePairedTest}} -> \code{\link[LearnNonparam:TwoSampleAssociationTest]{LearnNonparam::TwoSampleAssociationTest}} -> \code{Correlation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Correlation-new}{\code{Correlation$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Correlation-new"></a>}}
\if{latex}{\out{\hypertarget{method-Correlation-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Correlation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Correlation$new(
  type = c("permu", "asymp"),
  method = c("pearson", "kendall", "spearman"),
  alternative = c("two_sided", "less", "greater"),
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{method}}{a character string specifying the correlation coefficient to be used.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to zero (default) then all permutations are used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Correlation} object.
}
}
}
