% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_LeMans.R
\name{get_N0}
\alias{get_N0}
\title{Generate a starting value for N}
\usage{
get_N0(nsc, nfish, mid, wgt, sc_Linf, intercept = 1e+10, slope = -5)
}
\arguments{
\item{nsc}{A numeric value representing the number of length classes in the model.}

\item{nfish}{A numeric value representing the number of fish species in the model.}

\item{mid}{A numeric vector of length \code{nfish} representing the mid-point of the length classes.}

\item{wgt}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class.}

\item{sc_Linf}{A numeric vector of length \code{nsc} representing the length class at which each species reaches its asymptotic length.}

\item{intercept}{A numeric value representing the number of individuals in the first length class. The default is \code{1e10}.}

\item{slope}{A numeric value representing the slope of the community size spectrum. The default is -5.}
}
\value{
A matrix with dimensions \code{nsc} and \code{nfish} representing the number of individuals in each length class.
}
\description{
Generate a starting value for \code{N}, which represents the number of individuals in each length class for each species.
}
\details{
The total number of individuals in the community in each length class is equal to \code{intercept*mid^slope}. Within each length class, the number of individuals of each species is determined using the proportion of each species' biomass that is found in that length class.
}
\examples{
# Set up the inputs to the function
nfish <- nrow(NS_par)
nsc <- 32
maxsize <- max(NS_par$Linf)*1.01 # the biggest size is 1\% bigger than the largest Linf
l_bound <- seq(0, maxsize, maxsize/nsc); l_bound <- l_bound[-length(l_bound)]
u_bound <- seq(maxsize/nsc, maxsize, maxsize/nsc)
mid <- l_bound+(u_bound-l_bound)/2

# Set up the inputs to the function - species-specific parameters
Linf <- NS_par$Linf # the von-Bertalanffy asymptotic length of each species (cm).
W_a <- NS_par$W_a # length-weight conversion parameter.
W_b <- NS_par$W_b # length-weight conversion parameter.
k <- NS_par$k # the von-Bertalnaffy growth parameter.
Lmat <- NS_par$Lmat # the length at which 50\\\% of individuals are mature (cm).

# Get phi_min
tmp <- calc_phi(k, Linf, nsc, nfish, u_bound, l_bound, calc_phi_min=FALSE,
                  phi_min=0.1) # fixed phi_min
phi_min <- tmp$phi_min

# Calculate growth increments
tmp <- calc_ration_growthfac(k, Linf, nsc, nfish, l_bound, u_bound, mid, W_a, W_b, phi_min)
sc_Linf <- tmp$sc_Linf
wgt <- tmp$wgt

# Get an initial population
get_N0(nsc, nfish, mid, wgt, sc_Linf)
}
\references{
Andersen, K.H., Blanchard, J.L., Fulton, E.A., Gislason, H., Jacobsen, N.S., van Kooten, T. (2016). Assumptions behind size-based ecosystem models are realistic. \emph{ICES Journal of Marine Science}, 73(6):1651-1655.
}
\seealso{
\code{\link{run_LeMans}}
}
